﻿#pragma once
#include <Multimedia/SDX.h>
#include <Multimedia/Window.h>
#include <Multimedia/Sound.h>

namespace SDX
{
/** BGM用音声を表すクラス.*/
///	\include MusicSample.h
class Music
{
private:
	std::string fileName;
	int volume;
#ifdef SDL
	Mix_Music* handle;
#endif

public:
	Music(){};
	~Music(){};
	
	/** 音声ファイルを登録.*/
	Music(const char *ファイル名 , double 音量 = 1.0)
	{
		Music::Load( ファイル名 , 音量 );
	}
	
	/** 音声ファイルを登録.*/
	///音量は 0～1.0で指定、ファイルはメモリには読み込まない。
	void Load(const char *ファイル名 , double 音量 = 1.0)
	{
		this->fileName = ファイル名;
		#ifdef SDL
		handle = Mix_LoadMUS(ファイル名);				
		#endif
		volume = int(音量*255);
	}
		
	/** 音声ファイルを再生.*/
	///Musicファイルは複数同時に再生する事は出来ない。
	///現在再生中の音声は停止する。
	bool Play(PlayType 再生方法 = PlayType::Back)
	{
	#ifdef DXLIB
		const bool ok = !DxLib::PlayMusic(this->fileName.c_str(), (int)再生方法);
		DxLib::SetVolumeMusic( volume );
		return ok;
	#elif defined(SDL)
		switch (再生方法)
		{
		case PlayType::Back:
			Mix_PlayMusic(handle, 1);
			break;
		case PlayType::Loop:
			Mix_PlayMusic(handle, -1);
			break;
		}
		Mix_VolumeMusic(volume/2);
		return true;
	#endif
	}

	/** 再生中か取得.*/
	///いずれかのMusicが再生中ならtureを返す
	static bool Check()
	{
	#ifdef DXLIB
		return !DxLib::CheckMusic();
	#elif defined(SDL)
		return !Mix_PlayingMusic();
	#endif
	}

	/** 再生中のMusicを停止.*/
	static bool Stop()
	{
	#ifdef DXLIB
		return !DxLib::StopMusic();
	#elif defined(SDL)
		return !Mix_HaltMusic();
	#endif
	}
};
}