﻿#pragma once
#include <Multimedia/Color.h>

namespace SDX
{
/** Font,BmpFont等のインターフェース.*/
///	\include FontSample.h
class IFont
{
public:
	/** 書式付きで文字を描画.*/
	virtual bool Draw(int X座標 , int Y座標 ,  Color 色 ,const char *描画文字列 , ...) const = 0;
	virtual bool ZMask(int X座標, int Y座標, ZMaskType Zマスクタイプ, const char *str, ...) const = 0;
	
	/** 拡大率を指定して文字を描画.*/
	virtual bool DrawExtend(int X座標, int Y座標, double X軸拡大率, double Y軸拡大率, Color 色, const char *描画文字列, ...) const = 0;
	virtual bool ZMaskExtend(int X座標, int Y座標, double X軸拡大率, double Y軸拡大率, ZMaskType Zマスクタイプ, const char *str, ...) const = 0;
};
}