﻿#pragma once
#include<Multimedia/SDX.h>
#include<Multimedia/Color.h>
#include<Multimedia/Image.h>

namespace SDX
{
/** リソースを読み込まずに描画を行う関数群.*/
///	\include DrawingSample.h
class Drawing
{
private:
	Drawing();
	~Drawing();

#ifdef SDL
	//透過状態を計算する
	void RGBACulculate(int 赤 , int 緑 , int 青) const
	{
		SDL_SetRenderDrawBlendMode(Screen::GetHandle(), (SDL_BlendMode)Screen::Single().nowBlendMode);
		SDL_SetRenderDrawColor
			(
				Screen::GetHandle(),
				Screen::Single().rgba.GetRed() * 赤 / 255,
				Screen::Single().rgba.GetGreen() * 緑 / 255,
				Screen::Single().rgba.GetBlue() * 青 / 255,
				Screen::Single().blendParam
			);
	}
#endif

public:
	/** 始点と終点を結ぶ直線を描画.*/
	static bool Line(int 始点X, int 始点Y, int 終点X, int 終点Y, Color 色, int 太さ)
	{
	#ifdef DXLIB
		return !DxLib::DrawLine( 始点X , 始点Y , 終点X , 終点Y , 色 , 太さ );
	#elif defined(SDL)
		SDL_SetRenderDrawColor(Screen::GetHandle(), 色.GetRed(), 色.GetGreen(), 色.GetBlue(), 0);
		return !SDL_RenderDrawLine(Screen::GetHandle(), 始点X, 始点Y, 終点X, 終点Y);
	#endif
	}

	/** 座標aと座標bを対角の頂点とする矩形を描画.*/
	static bool Rect(int 座標aX, int 座標aY, int 座標bX, int 座標bY, Color 色, bool 塗りつぶしフラグ)
	{
	#ifdef DXLIB
		return !DxLib::DrawBox( 座標aX , 座標aY , 座標bX , 座標bY , 色 , 塗りつぶしフラグ );
	#elif defined(SDL)
		SDL_Rect buf = { 座標aX, 座標aY, 座標bX - 座標aX, 座標bY - 座標aY };

		SDL_SetRenderDrawColor(Screen::GetHandle(), 色.GetRed(), 色.GetGreen(), 色.GetBlue(), 0);
		
		if (塗りつぶしフラグ)
		{
			return !SDL_RenderFillRect(Screen::GetHandle(), &buf);
		}else{
			return !SDL_RenderDrawRect(Screen::GetHandle(), &buf);
		}
	#endif
	}
	static bool RectZMask( int x1 , int y1 , int x2 , int y2 , ZMaskType type, bool isFill )
	{
	#ifdef DXLIB
		return !DxLib::DrawBoxToZBuffer( x1 , y1 , x2 , y2 , isFill , (int)type );
	#elif defined(SDL)
		return false;
	#endif
	}

	/** 中心と半径を指定して円を描画.*/
	static bool Circle(int 中心X, int 中心Y, int 半径, Color 色, bool 塗りつぶしフラグ)
	{
	#ifdef DXLIB
		return !DxLib::DrawCircle( 中心X , 中心Y , 半径 , 色 , 塗りつぶしフラグ );
	#elif defined(SDL)
		//SDL_SetRenderDrawColor(Screen::GetHandle(), 色.GetRed(), 色.GetGreen(), 色.GetBlue(), 0);
		//filledCircleRGBA(Screen::GetHandle() , 中心X , 中心Y , 半径 , 色.GetRed() , 色.GetGreen() , 色.GetBlue() , 0);
		return false;
	#endif
	}
	static bool CircleZMask(int 中心X, int 中心Y, int 半径, Color 色, bool 塗りつぶしフラグ)
	{
	#ifdef DXLIB
		return !DxLib::DrawCircleToZBuffer( 中心X , 中心Y , 半径 , 塗りつぶしフラグ , DX_ZWRITE_MASK );			
	#elif defined(SDL)
		return false;
	#endif
	}

	/** 中心と外接する四角形の大きさを指定して楕円を描画.*/
	static bool Oval( int 中心X , int 中心Y , int 幅 , int 高さ , Color 色 , bool 塗りつぶしフラグ )
	{
	#ifdef DXLIB
		return !DxLib::DrawOval( 中心X , 中心Y , 幅 , 高さ , 色 , 塗りつぶしフラグ );
	#elif defined(SDL)
		return false;
	#endif
	}

	/** 頂点を３つ指定して三角形を描画.*/
	static bool Triangle(int 頂点aX, int 頂点aY, int 頂点bX, int 頂点bY, int 頂点cX, int 頂点cY, ColorData 色, bool 塗りつぶしフラグ)
	{
	#ifdef DXLIB
		return !DxLib::DrawTriangle( 頂点aX , 頂点aY , 頂点bX , 頂点bY , 頂点cX , 頂点cY , 色 , 塗りつぶしフラグ);
	#elif defined(SDL)
		return false;
	#endif
	}

	/** 指定座標に点を描画.*/
	static bool Pixel(int 座標X, int 座標Y, Color 色)
	{
	#ifdef DXLIB
		return !DxLib::DrawPixel( 座標X , 座標Y , 色 );
	#elif defined(SDL)
		SDL_SetRenderDrawColor(Screen::GetHandle(), 色.GetRed(), 色.GetGreen(), 色.GetBlue(), 0);
		SDL_RenderDrawPoint(Screen::GetHandle() ,座標X, 座標Y);
		return false;
	#endif
	}

	/** 指定座標の色を取得.*/
	static ColorData GetPixel( int 座標X , int 座標Y )
	{
	#ifdef DXLIB
		return DxLib::GetPixel( 座標X , 座標Y );
	#elif defined(SDL)
		return SDL_Color{ 0, 0, 0 };
	#endif
	}

	/** 画像を一時的にメモリに読み込んで描画.*/
	///この処理は重いので、通常はImageクラスを利用する
	static bool ImageFile( int 座標X , int 座標Y , const char *ファイル名 , bool 透過フラグ = true )
	{
	#ifdef DXLIB
		return !DxLib::LoadGraphScreen( 座標X , 座標Y , ファイル名 , 透過フラグ);
	#elif defined(SDL)
		Image buf(ファイル名);
		buf.Draw(座標X , 座標Y , false);
		buf.Release();
		return true;
	#endif
	}

	/** 書式付きで文字を描画.*/
	///フォントはデフォルトでゴシック体
	static void String( int X座標 , int Y座標 , Color 色 , const char *文字列 , ... )
	{
		char bufstr[1024];
		va_list args;
		va_start(args,文字列);
		vsprintf_s( bufstr , 1024 , 文字列 , args );
		va_end(args);

		char *pstr,*stro;
		stro = strtok_s( bufstr , "\n" , &pstr );

		while(stro != NULL)
		{
		#ifdef DXLIB
			DxLib::DrawString( X座標 , Y座標 , stro , 色 );
		#elif defined(SDL)
			
		#endif
			stro = strtok_s( NULL , "\n" , &pstr );
			Y座標 += 20;
		}
	}

	static void StringZMask( int X座標 , int Y座標 , ZMaskType Zマスク , const char *文字列 , ... )
	{
		char bufstr[1024];
		va_list args;
		va_start(args,文字列);
		vsprintf_s( bufstr , 1024 , 文字列 , args );
		va_end(args);

		char *pstr,*stro;
		stro = strtok_s( bufstr , "\n" , &pstr );

		while(stro != NULL)
		{
		#ifdef DXLIB
			DxLib::DrawStringToZBuffer( X座標 , Y座標 , stro , (int)Zマスク);
		#elif defined(SDL)

		#endif		
			stro = strtok_s( NULL , "\n" , &pstr );
			Y座標 += 20;
		}

	}
};
}