﻿#pragma once
#include <Framework/Sprite.h>

namespace SDX
{
/** Imageスプライト.*/
///	\include ModelSample.h
class SpImage : public Sprite
{
private:
	const Image *image;

public:
	SpImage(const Image *image ):
		image(image)
	{}

	void Draw( double x , double y , bool isCamera)
	{
		if( isCamera )
		{
			image->DrawRotateAxis(		(int)Camera::Now()->TransX(x + gapX) ,
										(int)Camera::Now()->TransY(y + gapY) ,
										(int)(axisX * Camera::Now()->GetZoom() ) + image->GetWidth() / 2, 
										(int)(axisY * Camera::Now()->GetZoom() ) + image->GetHeight() / 2, 
										zoomX * Camera::Now()->GetZoom() ,
										zoomY * Camera::Now()->GetZoom() ,
										angle , isTurn);
		}else{
			image->DrawRotateAxis(		(int)(x + gapX) ,
										(int)(y + gapY),
										(int)axisX + image->GetHeight() / 2, 
										(int)axisY + image->GetHeight() / 2, 
										zoomX ,
										zoomY ,
										angle , isTurn);
		}
	}		
};

/** Animeスプライト.*/
///	\include
class SpAnime : public Sprite
{
private:
	const Anime *anime;
	Anime::Player counter;
	double aniSpeed;

public:

	SpAnime(const Anime *anime , double aniSpeed = 1) :
			anime( anime ),
			counter( anime ),
			aniSpeed( aniSpeed )
	{}

	void AnimeUpdate()
	{
		counter.UpDate( aniSpeed );
	};

	void Draw( double x , double y ,bool isCamera)
	{
		if( isCamera )
		{
			counter.GetFrame()->DrawRotateAxis( 
										(int)Camera::Now()->TransX(x + gapX) , 
										(int)Camera::Now()->TransY(y + gapY) ,
										(int)(axisX * Camera::Now()->GetZoom()) + anime->GetWidth() / 2, 
										(int)(axisY * Camera::Now()->GetZoom()) + anime->GetHeight() / 2,
										zoomX * Camera::Now()->GetZoom() ,
										zoomY * Camera::Now()->GetZoom(),
										angle ,
										isTurn);
		}
		else
		{
			counter.GetFrame()->DrawRotateAxis(
										(int)(x +gapX),
										(int)(y +gapY),
										(int)axisX + anime->GetWidth() / 2,
										(int)axisY + anime->GetHeight() / 2,
										zoomX ,
										zoomY ,
										angle , isTurn);
		}
	}
};
	
/** Fontスプライト.*/
///	\include
class SpFont : public Sprite
{
private:
	const IFont *font;
	std::string str;
	Color rgb;

public:
	SpFont(const IFont *font ,  Color rgb  , const char *str ):
		font(font),
		rgb(rgb),
		str(str)
	{}
	
	void Draw( double x , double y  ,bool isCamera)
	{
		if( isCamera )
		{
			font->DrawExtend( (int)Camera::Now()->TransX(x) , (int)Camera::Now()->TransY(y) , zoomX * Camera::Now()->GetZoom() , zoomY * Camera::Now()->GetZoom() , rgb , str.c_str() );
		}
		else
		{
			font->DrawExtend((int)x, (int)y, zoomX, zoomY, rgb, str.c_str());
		}
	}
};

/** IFrameスプライト.*/
///	\include
class SpFrame : public Sprite
{
private:
	const IFrame *bmpFrame;
	double width;
	double height;

public:
	SpFrame(const IFrame *bmpFrame , double width , double height ):
		bmpFrame(bmpFrame),
		width(width),
		height(height)
	{}

	void Draw( double x , double y ,bool isCamera)
	{
		if( isCamera )
		{
			bmpFrame->Draw(	(int)Camera::Now()->TransX(x) ,
							(int)Camera::Now()->TransY(y) ,
							(int)(width * zoomX * Camera::Now()->GetZoom()) ,
							(int)(height * zoomY * Camera::Now()->GetZoom()));
		}
		else
		{
			bmpFrame->Draw(	(int)x ,
							(int)y ,
							(int)(width * zoomX) ,
							(int)(height * zoomY) );
		}
	}
};


/** マップチップスプライト.*/
///	\include
class SpMap : public Sprite
{
private:
	ImagePack &chip;
	int width;
	int height;
	int rotate;
	std::vector< std::vector<int> > data;
public:

	SpMap( ImagePack& マップチップ , const char* ファイル名 , int 幅 , int 高さ , int 角度):
		width(幅),
		height(高さ),
		rotate(角度),
		chip(マップチップ)
	{
		File csvFile( ファイル名 , FileMode::Read );

		data.resize( 幅 );

		for(int i=0 ; i<幅 ;++i)
		{
			data[i].resize( 高さ );
		}

		std::vector<std::string> lineBuf;

		for(int i = 0 ; i < 高さ ; ++i )
		{
			csvFile.GetLineCSV( lineBuf );
			for( int j = 0 ; j < 幅 ; j++)
			{
				data[j][i] = atoi( lineBuf[j].c_str() );
			}
			lineBuf.clear();
		}
	}

	void Draw( double X座標 , double Y座標 ,bool カメラ有りフラグ)
	{
		const int chipW = chip.GetWidth();
		const int chipH = chip.GetHeight();

		if( カメラ有りフラグ )
		{
			const int baseY = int(Camera::Now()->TransY( Y座標 ));
			const int baseX = int(Camera::Now()->TransX( X座標 ));
			
			int posXA;
			int posYA;
			int posXB;
			int posYB;

			for(int i=0 ; i<width ; ++i )
			{
				posXA = int( baseX + chipW * i * Camera::Now()->GetZoom() );
				posXB = int( baseX + chipW * (i+1) * Camera::Now()->GetZoom() );

				for(int j=0 ; j<height ; ++j )
				{
					posYA = int( baseY + chipH * j * Camera::Now()->GetZoom() );
					posYB = int( baseY + chipH * (j+1) * Camera::Now()->GetZoom() );
					const int no = data[i][j];
					if( no == 0 ) continue;
					chip[no]->DrawExtend( posXA , posYA , posXB , posYB );
				}
			}
		}else{
			for(int i=0 ; i<width ; ++i )
			{
				for(int j=0 ; j<height ; ++j )
				{
					const int no = data[i][j];
					if( no == 0 ) continue;
					chip[no]->Draw( int(X座標 + i*chipW) , int(Y座標 + j*chipH) );
				}
			}
		}
	}

};
}