﻿#pragma once
#include <SDXFrameWork.h>

namespace SDX
{
/** Modelの移動を行うクラス.*/
///	\include ModelSample.h
class ModelMove
{
public:
	Model *model;
	
	ModelMove(Model *移動対象):
		model(移動対象)
	{}

	/** Modelの向きに移動.*/
	void 前進(double 速度)
	{
		model->MovePolar(速度, model->GetAngle());
	}

	/** 角度を指定して移動.*/
	void 直進(double 速度, double 角度)
	{
		model->MovePolar(速度, 角度);
	}

	/** 範囲外に出ると反転する.*/
	void 跳ね返り(double 速度, double &角度, Rect &移動範囲)
	{
		//範囲外にいる
		if (model->GetX() < 移動範囲.GetLeft())
		{
			if (角度 > PAI / 2 && 角度 < PAI * 3 / 2)
			{
				角度 = -PAI - 角度;
			}
		}

		if (model->GetX() > 移動範囲.GetRight())
		{
			if (角度 < PAI / 2 || 角度 > PAI * 3 / 2)
			{
				角度 = PAI - 角度;
			}
		}
		else if (model->GetY() < 移動範囲.GetTop())
		{
			if (角度 > PAI)
			{
				角度 = PAI * 2 - 角度;
			}
		}
		else if (model->GetY() > 移動範囲.GetBottom())
		{
			if (角度 < PAI)
			{
				角度 = -角度;
			}
		}

		if (角度 < 0) 角度 += PAI * 2;
		if (角度 > PAI * 2) 角度 -= PAI * 2;

		model->MovePolar(速度, 角度);
	}

	/** 目標座標まで移動.*/
	bool 指定移動(double 速度, double 目標X, double 目標Y)
	{
		const double lx = 目標X - model->GetX();
		const double ly = 目標Y - model->GetY();

		if (lx * lx + ly * ly <= 速度 * 速度)
		{
			model->SetPos(目標X, 目標Y);
			return true;
		}
		else{
			const double angle = atan2(ly, lx);
			model->MovePolar(速度, angle);
			return false;
		}
	}

	struct 円軌道状態
	{
		円軌道状態(double 初角) :
		角度(初角)
		{}

		double 角度;
		double 前位置X;
		double 前位置Y;
		bool   初期化フラグ = false;
	};

	/** 円周上を移動.*/
	void 円軌道( double 角速度, 円軌道状態 &状態, double 半径X, double 半径Y)
	{
		if (!状態.初期化フラグ)
		{
			状態.前位置X = cos(状態.角度) * 半径X;
			状態.前位置Y = sin(状態.角度) * 半径Y;
		}
		
		状態.角度 += 角速度;

		const double nextX = cos(状態.角度) * 半径X;
		const double nextY = sin(状態.角度) * 半径Y;

		model->Move(nextX - 状態.前位置X, nextY - 状態.前位置Y);

		状態.前位置X = nextX;
		状態.前位置Y = nextY;
	}

	struct 振動状態
	{
		double 移動量X = 0;
		double 移動量Y = 0;
	};

	/** 範囲内でランダムに移動.*/
	void 振動(振動状態 &状態, double X振幅, double Y振幅)
	{
		状態.移動量X = Rand::Get(-X振幅, X振幅) - 状態.移動量X;
		状態.移動量Y = Rand::Get(-Y振幅, Y振幅) - 状態.移動量Y;
		model->Move(状態.移動量X, 状態.移動量Y);
	}
};
}