﻿#pragma once
#include <Framework/IScene.h>
#include <Utility/Timer.h>
#include <Multimedia/Input.h>
#include <Framework/Camera.h>

namespace SDX
{
/** シーンを管理するクラス.*/
///	\include DirectorSample.h
class Director
{
private:
	std::list< std::shared_ptr<IScene> > scenes;

	Director(){};

	static Director& Single()
	{
    	static Director instance; 
    	return instance;
	}
public:
	/** 実行開始.*/
	static void Run()
	{
		Time::ResetFPS();

		while( System::Update() )
		{
			if( Single().scenes.size() == 0 ) break;
			Single().scenes.back()->Update();
			Single().scenes.back()->Draw();
			//更新処理
			if( Camera::Now() ) Camera::Now()->Update();
			Time::CheckFPS();

			Remove();
		}
	}

	/** 消滅したSceneを片付ける.*/
	static void Remove()
	{
		auto it = Single().scenes.begin();

		while( it != Single().scenes.end() )
		{
			if( (*it)->IsEnd() )
			{
				Single().scenes.remove( (*it) );
				if(Single().scenes.size() == 0 )break;
				continue;
			}
			it++;
		}
	}

	/** Sceneをアクティブにする.*/
	static void SetActive( IScene* scene )
	{
		//既に存在する場合追加のみ
		auto it = Single().scenes.begin();
		while( it != Single().scenes.end() )
		{
			if( (*it).get() == scene  )
			{
				Single().scenes.push_back( std::shared_ptr<IScene>(scene) );
				Single().scenes.remove( (*it) );
				return;
			}
			break;
		}
		//存在していない場合初期化もする
		scene->Init();
		Single().scenes.push_back( std::shared_ptr<IScene>(scene) );
	}
};
}









