﻿#pragma once
#include <Multimedia/Image.h>
#include <Multimedia/Font.h>
#include <Framework/BmpFont.h>
#include <Framework/Anime.h>

namespace SDX
{

/** 描画用枠のインターフェース.*/
///	\include BmpFrameSample.h
class IFrame
{
public:
	virtual void Draw(int X座標, int Y座標, int 幅, int 高さ) const = 0;
};

/** 描画用枠を表すクラス.*/
///	\include BmpFrameSample.h
class BmpFrame : public IFrame
{
private:
	bool isMake;
	int frameWidth;
	int frameHeight;
	ImagePack *frame;
	Image   *skinn;
public:
	/** フレームを作成する.*/
	///３×３分割したImagePackを元にフレームを作成
	///内側スキンを省略した場合、外枠の中央を使う
	bool Make( ImagePack *外枠 , Image *内側スキン = nullptr  )
	{
		if( 外枠->GetSize() != 9  ) return false;

		if( 内側スキン == nullptr )
		{
			this->skinn = 外枠[0][4];
		}else{
			this->skinn = 内側スキン;
		}

		this->frame = 外枠;

		this->isMake = true;

		this->frameWidth = 外枠->GetWidth();
		this->frameHeight = 外枠->GetHeight();

		return true;
	}
	
	/** 矩形のフレームを描画.*/
	///右上座標を指定してフレームを描画する
	void Draw( int X座標, int Y座標, int 幅, int 高さ) const
	{
		const int xA = X座標 + this->frameWidth;
		const int xB = X座標 - this->frameWidth + 幅;
		const int yA = Y座標 + this->frameHeight;
		const int yB = Y座標 - this->frameHeight + 高さ;

		//内部スキンを描画
		skinn->DrawExtend(X座標 + 6, Y座標 + 6, X座標 + 幅 - 6, Y座標 + 高さ - 6);
		
		//まず外枠を描画	
		frame[0][3]->DrawExtend(X座標, yA, xA, yB);
		frame[0][5]->DrawExtend(xB, yA, xB + this->frameWidth, yB);

		frame[0][1]->DrawExtend(xA, Y座標, xB, yA);
		frame[0][7]->DrawExtend(xA, yB, xB, yB + this->frameHeight);
		
		//四隅を描画
		frame[0][0]->Draw(X座標, Y座標);
		frame[0][2]->Draw(X座標 + 幅 - this->frameWidth, Y座標);
		frame[0][6]->Draw(X座標, Y座標 + 高さ - this->frameHeight);
		frame[0][8]->Draw(X座標 + 幅 - this->frameWidth, Y座標 + 高さ - this->frameHeight);
	}
};
}