#include	"dv_repeater.h"

void	putFifo (int len, struct dv_packet pkt);
int	getFifo (int *len, struct dv_packet *pkt);
void    send_rep_position(void);
void	send_echo_position (void);

int     init(int argc, char **argv);
extern	char	lastframe[];
extern	char	echo_buff[];
int	buff_length;
struct	dv_packet buff_pkt;


enum
{
	SEND_PACKET = 0,
	SEND_PACKET_WAIT,
	SEND_INIT,
	SEND_INIT_WAIT
} dv_packet = SEND_INIT; 
	
void	send_gateway(void)
{
	int	ret;

	switch (dv_packet)
	{
		case SEND_PACKET:
			if (getFifo (&buff_length, &buff_pkt))
			{
				buff_pkt.m[0] = (m >> 8) & 0xff;
				buff_pkt.m[1] = m & 0xff;
				time (&cur_time);
          	    		ret = sendto(out_sd, &buff_pkt, buff_length, 0,
               				 gateway_out->ai_addr, gateway_out->ai_addrlen);
                        	if (ret < 0) {
                                	fprintf (log_file, "%24.24s packet sent error %s\n",
                                        	ctime(&cur_time), strerror(errno));
                                	fflush (log_file);
                                	break;
                        	}
				dv_packet = SEND_PACKET_WAIT;
				time(&send_time);
			}
			break;

		case SEND_PACKET_WAIT:
                       	if (!recv_check()) break;
                        if (seq_check ())
                        {
                        	dv_packet = SEND_PACKET;
			}
			else			/* re send */
			{
				ret = sendto(out_sd, &buff_pkt, buff_length, 0,
					gateway_out->ai_addr, gateway_out->ai_addrlen);
				if (ret < 0) {
					fprintf (log_file, "%24.24s packet re-sent error %s\n",
						ctime(&cur_time), strerror(errno));
					fflush (log_file);
				}
			}
			break;

		case SEND_INIT:
                        memcpy (posit.id, "DSTR", 4);
                        posit.sr = 's';
                        posit.c= 0x00;          /* null */
                        posit.length[0] = 0x00;
                        posit.length[1] = 0x00;         /* length 0 */
                        posit.m[0] = m >> 8;
                        posit.m[1] = m & 0xff;
                        ret = sendto(out_sd, &posit, 10, 0,
                                gateway_out->ai_addr, gateway_out->ai_addrlen);
                        if (ret < 0) {
                                fprintf (log_file, "%24.24s null(sync) packet sent error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
			dv_packet = SEND_INIT_WAIT;
			time(&send_time);
			break;

		case SEND_INIT_WAIT:
                        if (!recv_check()) break;
                        if (seq_check ())
                        {
                                dv_packet = SEND_PACKET;
				init_sw = TRUE;
                        }
			else
			{
                                 if (debug)
                                 {
                                         time (&cur_time);
                                         fprintf (log_file, "%24.24s dsgwd sequence number changed from %d(0x%4.4x) to %d(0x%4.4x)\n",
                                         ctime (&cur_time), m, m & 0xffff, recv_m, recv_m & 0xffff);
                                         fflush (log_file);
                                 }
                        	m = recv_m;
                        	dv_packet = SEND_INIT;
			}
                        break;
	}
}

void	reset_gateway(void)
{
	dv_packet = SEND_INIT;
}

void	send_sys_position(void)
{
	struct	timeval	tmp_tm;

	/* sending to INET (dsgwd) */
	if (!init_sw) return;
	timersub (&tm1, &tm0, &tmp_tm);
	if (sys_timeout.tv_sec != 0)
	{
		if (timercmp (&tmp_tm, &sys_timeout, >))
		{
			timeradd (&tm0, &sys_timeout, &tmp_tm);
			tm0.tv_sec = tmp_tm.tv_sec;
			tm0.tv_usec = tmp_tm.tv_usec;
			if (debug)
			{
				time (&cur_time);
				fprintf (log_file, "%24.24s sent POSITION Info (seq:%d(0x%4.4x))\n", 
					ctime(&cur_time), m, m & 0xffff);
				fflush (log_file);
			}
                       	memcpy (posit.id, "DSTR", 4);
                       	posit.sr = 's';
                       	posit.c= 0x00;          /* null */
                       	posit.length[0] = 0x00;
                       	posit.length[1] = 0x00;		/* length 0 */

			putFifo (10, posit);


			memcpy (posit.id, "DSTR", 4);
			memcpy (posit.dstar.posit.call1, sys_call, 8);
			memcpy (posit.dstar.posit.call2, sys_call, 8);
			posit.sr = 's';
			posit.c = 0x21;		/* position */
			posit.length[0] = 0x00;
			posit.length[1] = 0x10;		/* length 16 */
			putFifo (26, posit);
		}
		if (!rep_position_send_sw) send_rep_position();
	}
}

void	send_rep_position(void)
{
	rep_position_send_sw = TRUE;

	if (dvap_area_rep_callsign[0] != 0x20)
	{
		memcpy (posit.dstar.posit.call1, 
			dvap_area_rep_callsign, 8);
		memcpy (posit.dstar.posit.call2, 
			dvap_area_rep_callsign, 8);
		putFifo (26, posit);
	}

	if (node_area_rep_callsign[0] != 0x20)
	{
		memcpy (posit.dstar.posit.call1,
			node_area_rep_callsign, 8);
		memcpy (posit.dstar.posit.call2,
			node_area_rep_callsign, 8);
		putFifo (26, posit);
	}

}

void    send_echo_position(void)
{
	if (echo_server[0] == 0x20) return;

        memcpy (echo_posit.id, "DSTR", 4);
        memcpy (echo_posit.dstar.posit.call1, echo_server, 8);
        memcpy (echo_posit.dstar.posit.call2, echo_area_rep_callsign, 8);
        echo_posit.sr = 's';
        echo_posit.c= 0x21;          /* position */
        echo_posit.length[0] = 0x00;
        echo_posit.length[1] = 0x10;         /* length 16 */

        putFifo (26, echo_posit);
	if (debug)
	{
		fprintf (log_file, "%24.24s Echo Server Position sent\n", ctime (&echo_position_send_time));
		fflush (log_file);
	}
	echo_position_send_time += echo_position_send_interval;
}

enum
{
	AREA1_PACKET = 0,
	AREA1_PACKET_WAIT,
	AREA1_INIT,
	AREA1_INIT_WAIT
} area1_packet = AREA1_INIT; 
	
void	send_area1(void)
{
	int	ret;

	switch (area1_packet)
	{
		case AREA1_PACKET:
			if (getArea1Fifo (&buff_length, &buff_pkt))
			{
				buff_pkt.m[0] = area1_m >> 8;
				buff_pkt.m[1] = area1_m & 0xff;
				time (&cur_time);
          	    		ret = sendto(area1_sd, &buff_pkt, buff_length, 0,
               				 area1_out->ai_addr, area1_out->ai_addrlen);
                        	if (ret < 0) {
                                	fprintf (log_file, "%24.24s packet sent error %s\n",
                                        	ctime(&cur_time), strerror(errno));
                                	fflush (log_file);
                                	break;
                        	}
				area1_packet = AREA1_PACKET_WAIT;
			}
			break;

		case AREA1_PACKET_WAIT:
                       	if (!area1_recv_check()) break;
                        if (area1_seq_check ())
                        {
                        	area1_packet = AREA1_PACKET;
			}
	
			break;

		case AREA1_INIT:
                        memcpy (posit.id, "DSTR", 4);
                        posit.sr = 's';
                        posit.c= 0x00;          /* null */
                        posit.length[0] = 0x00;
                        posit.length[1] = 0x00;         /* length 0 */
                        posit.m[0] = (area1_m >> 8) & 0xff;
                        posit.m[1] = area1_m & 0xff;
                        ret = sendto(out_sd, &posit, 10, 0,
                                area1_out->ai_addr, area1_out->ai_addrlen);
                        if (ret < 0) {
                                fprintf (log_file, "%24.24s null(sync) packet sent error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
			area1_packet = AREA1_INIT_WAIT;
			break;

		case AREA1_INIT_WAIT:
                        if (!area1_recv_check()) break;
                        if (area1_seq_check ())
                        {
                                area1_packet = AREA1_PACKET;
				init_sw = TRUE;
                        }
			else
			{
                                 if (debug)
                                 {
                                         time (&cur_time);
                                         fprintf (log_file, "%24.24s dsgwd sequence number changed from %d(0x%4.4x) to %d(0x%4.4x)\n",
                                         ctime (&cur_time), m, m & 0xffff, recv_m, recv_m & 0xffff);
                                         fflush (log_file);
                                 }
                        	area1_m = area1_recv_m;
                        	area1_packet = AREA1_INIT;
			}
                        break;
	}
}

enum
{
	AREA2_PACKET = 0,
	AREA2_PACKET_WAIT,
	AREA2_INIT,
	AREA2_INIT_WAIT
} area2_packet = AREA1_INIT; 
	
void	send_area2(void)
{
	int	ret;

	switch (area2_packet)
	{
		case AREA2_PACKET:
			if (getArea1Fifo (&buff_length, &buff_pkt))
			{
				buff_pkt.m[0] = (area2_m >> 8) & 0xff;
				buff_pkt.m[1] = area2_m & 0xff;
				time (&cur_time);
          	    		ret = sendto(area1_sd, &buff_pkt, buff_length, 0,
               				 area1_out->ai_addr, area1_out->ai_addrlen);
                        	if (ret < 0) {
                                	fprintf (log_file, "%24.24s packet sent error %s\n",
                                        	ctime(&cur_time), strerror(errno));
                                	fflush (log_file);
                                	break;
                        	}
				area2_packet = AREA2_PACKET_WAIT;
			}
			break;

		case AREA2_PACKET_WAIT:
                       	if (!area2_recv_check()) break;
                        if (area2_seq_check ())
                        {
                        	area2_packet = AREA2_PACKET;
			}
	
			break;

		case AREA2_INIT:
                        memcpy (posit.id, "DSTR", 4);
                        posit.sr = 's';
                        posit.c= 0x00;          /* null */
                        posit.length[0] = 0x00;
                        posit.length[1] = 0x00;         /* length 0 */
                        posit.m[0] = (area2_m >> 8) & 0xff;
                        posit.m[1] = area2_m & 0xff;
                        ret = sendto(out_sd, &posit, 10, 0,
                                area2_out->ai_addr, area2_out->ai_addrlen);
                        if (ret < 0) {
                                fprintf (log_file, "%24.24s null(sync) packet sent error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
			area2_packet = AREA2_INIT_WAIT;
			break;

		case AREA2_INIT_WAIT:
                        if (!area2_recv_check()) break;
                        if (area2_seq_check ())
                        {
                                area2_packet = AREA2_PACKET;
				init_sw = TRUE;
                        }
			else
			{
                                 if (debug)
                                 {
                                         time (&cur_time);
                                         fprintf (log_file, "%24.24s dsgwd sequence number changed from %d(0x%4.4x) to %d(0x%4.4x)\n",
                                         ctime (&cur_time), m, m & 0xffff, recv_m, recv_m & 0xffff);
                                         fflush (log_file);
                                 }
                        	area2_m = area2_recv_m;
                        	area2_packet = AREA2_INIT;
			}
                        break;
	}
}


enum
{
	AREA3_PACKET = 0,
	AREA3_PACKET_WAIT,
	AREA3_INIT,
	AREA3_INIT_WAIT
} area3_packet = AREA1_INIT; 
	
void	send_area3(void)
{
	int	ret;

	switch (area3_packet)
	{
		case AREA3_PACKET:
			if (getArea1Fifo (&buff_length, &buff_pkt))
			{
				buff_pkt.m[0] = (area3_m >> 8) & 0xff;
				buff_pkt.m[1] = area3_m & 0xff;
				time (&cur_time);
          	    		ret = sendto(area1_sd, &buff_pkt, buff_length, 0,
               				 area1_out->ai_addr, area1_out->ai_addrlen);
                        	if (ret < 0) {
                                	fprintf (log_file, "%24.24s packet sent error %s\n",
                                        	ctime(&cur_time), strerror(errno));
                                	fflush (log_file);
                                	break;
                        	}
				area3_packet = AREA3_PACKET_WAIT;
			}
			break;

		case AREA3_PACKET_WAIT:
                       	if (!area3_recv_check()) break;
                        if (area3_seq_check ())
                        {
                        	area3_packet = AREA3_PACKET;
			}
	
			break;

		case AREA3_INIT:
                        memcpy (posit.id, "DSTR", 4);
                        posit.sr = 's';
                        posit.c= 0x00;          /* null */
                        posit.length[0] = 0x00;
                        posit.length[1] = 0x00;         /* length 0 */
                        posit.m[0] = area3_m >> 8;
                        posit.m[1] = area3_m & 0xff;
                        ret = sendto(out_sd, &posit, 10, 0,
                                area3_out->ai_addr, area3_out->ai_addrlen);
                        if (ret < 0) {
                                fprintf (log_file, "%24.24s null(sync) packet sent error %s\n",
                                        ctime(&cur_time), strerror(errno));
                                fflush (log_file);
                                break;
                        }
			area3_packet = AREA3_INIT_WAIT;
			break;

		case AREA3_INIT_WAIT:
                        if (!area3_recv_check()) break;
                        if (area3_seq_check ())
                        {
                                area3_packet = AREA3_PACKET;
				init_sw = TRUE;
                        }
			else
			{
                                 if (debug)
                                 {
                                         time (&cur_time);
                                         fprintf (log_file, "%24.24s dsgwd sequence number changed from %d(0x%4.4x) to %d(0x%4.4x)\n",
                                         ctime (&cur_time), m, m & 0xffff, recv_m, recv_m & 0xffff);
                                         fflush (log_file);
                                 }
                        	area3_m = area3_recv_m;
                        	area3_packet = AREA3_INIT;
			}
                        break;
	}
}

