#include	"dv_repeater.h"

int     init(int argc, char **argv);
void	node_NoRespReply(struct dv_header NoResp);
void    dvap_NoRespReply(struct dv_header NoResp);
int	from_inet(void);
void	send_sys_position(void);
int	echo_server_send(struct echo *echo);
void	echo_server_last_ex (void);
void	echo_jitter_flush_ex(void);
void	send_echo (struct echo *echo);
void	send_pkt(void);
void	node_send_wait_set(void);
void	dvap_send_wait_set(void);
void	send_keep_alive(void);
void	dvap(void);
void	node_send_response(void);
void	dvap_send_response(void);
void	node_last_frame_send(void);
void	dvap_read(void);
void	send_echo_position (void);

extern	char	lastframe[];

int main(int argc, char **argv)
{
	int	ret;
	struct	timeval	tmp_tm;
	struct	timeval	one_sec;
	struct	timeval	two_sec;

	one_sec.tv_sec = 1;
	one_sec.tv_usec = 0;
	two_sec.tv_sec = 2;
	two_sec.tv_usec = 0;
	memset (echo_server, 0x20, 8);
	struct	echo *echo_next;

	if (init(argc, (char **)argv))
	{
		while (1)
		{
			memcpy (&rfds, &save_rfds, sizeof(save_rfds));
			memcpy (&sigset, &save_sigset, sizeof(save_sigset));
			ret = pselect (FD_SETSIZE, &rfds, (fd_set *)NULL, (fd_set *)NULL, &tv, &sigset);
			time(&cur_time);
			if (ret < 0)
			{
				fprintf (log_file, "%24.24s pselect error %s\n",
					ctime(&cur_time), strerror(errno));
				fflush (log_file);
				break;
			}
			if (ret > 0)
			{
				if (FD_ISSET (in_sd, &rfds))
				{
					if (!from_inet()) break;
				}
				if (dvap_sw && FD_ISSET (dvap_fd, &rfds))
				{
					dvap_read();
				}
				if (area1_port && FD_ISSET (area1_sd, &rfds))
				{
					area1_read();
				}
				if (area2_port && FD_ISSET (area2_sd, &rfds))
				{
					area2_read();
				}
				if (area3_port && FD_ISSET (area3_sd, &rfds))
				{
					area3_read();
				}
			}

                	/* read from rig (DV packket) */
			if (node_sw)
			{
				if (cos_check()) gettimeofday(&CosOffTime, NULL);
                		if (status & (HeaderDecodeDone | COS_OnOff)) 
                		{
                        		if (HeaderLength == 0) 
					{
						header_read_from_rig ();
					}
                        		else voice_read_from_rig();
                		}
                		else	/* last frame check */
                		{
				
                        		if (HeaderLength)
                        		{
                                		if (voice_read_from_rig() == 0)
						{
							if (node_last_frame_sw) node_last_frame_send();
							HeaderLength = 0;
							voice_pnt = 0;
							if (node_gw_resp_sw)
							{
								node_send_wait_set();
							}	
						}
                        		}
                		}
				node_send_response();
			}
			if (dvap_sw)
			{
				dvap();
				if ((cur_time - dvap_keep_alive) >= 2)
						send_keep_alive(); 
				dvap_send_response();
			}
			/* device re check */
			if (!(node_sw && dvap_sw))
			{
				if ((cur_time - re_check) > RECHECK)
				{
					if (!node_sw && (node_area_rep_callsign[0] != 0x20)) node_usb_init();
					if (!dvap_sw && (dvap_area_rep_callsign[0] != 0x20)) dvap_open();
					re_check = cur_time;
				}
			}
		
			gettimeofday (&tm1, NULL);
			timersub (&tm1, &InetInTime, &tmp_tm);
			if (timercmp(&tmp_tm, &two_sec,  >))
			{
				memset (node_save_frame_id, 0x00, 2);
				memset (dvap_save_frame_id, 0x00, 2);
			}
			send_sys_position ();	/* sending to INET (dsgwd) */

			echo_server_timeout_check();

			echo_next = echo_pnt;
			while (echo_next)
			{
				if (echo_server_send(echo_next)) echo_next = echo_pnt;
				else	echo_next = echo_next->next;
			}
			
			timersub (&tm1, &CosOffTime, &tmp_tm);
			if (timercmp (&tmp_tm, &one_sec, >))
			{
				if (node_NoRespReply_sw)
				{
					node_send_wait_set();
				}
				if (dvap_NoRespReply_sw)
				{		
					dvap_send_wait_set();
				}
			}
			echo_jitter_flush_ex();
			send_gateway();
			if (dvap_sw)
			{	
				if ((cur_time - dvap_in_time.tv_sec) > 3) dvap_close();
			}
			if (area1_port) send_area1();
			if (area2_port) send_area2();
			if (area3_port) send_area3();

			if (echo_position_send_interval)
			{
				time (&cur_time);
				if (cur_time >= echo_position_send_time)
					send_echo_position();
			}

			if (resp_timer.tv_sec || resp_timer.tv_usec) RespSend();
			if (sig_term) break;
			
		}
	}

	if (node_sw)
	{
		usb_reset (udev); 
		usb_close (udev);
	}
	if (dvap_sw)
	{
		dvap_close();
	}
	close(in_sd);
	time(&cur_time);
	fprintf (log_file, "%24.24s dv_repeater end\n", ctime(&cur_time));
	fclose (log_file);
	remove (PID_FILE);
	freeaddrinfo (gateway_in);
	freeaddrinfo (gateway_out);
	return 0;
}

