#include	"dv_repeater.h"

extern	int node_response_state;
void	node_term (void);
extern	char	lastframe[];

void    sig_init(void)
{
        sigemptyset (&save_sigset);
        sigaddset (&save_sigset, SIGUSR1);
        sigaddset (&save_sigset, SIGUSR2);
        sigaddset (&save_sigset, SIGTERM);
        sigaddset (&save_sigset, SIGINT);
}

void	node_close (void)
{
        usb_reset (udev);
        usb_close (udev);
	node_term();
}

void	node_term (void)
{
	node_NoRespReply_sw = FALSE;
	node_response_state = 0;
	node_gw_resp_sw = FALSE;
	node_last_frame_sw = FALSE;
	dvap_voice_send_sw = FALSE;
	memset (&node_save_frame_id, 0x00, 2);
	if (node_sw)
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s Node Adapter down.\n", ctime(&cur_time));
		fflush (log_file);
	}
	node_sw = FALSE;
}

void	dv_pkt_set(struct dv_packet *hdr)
{
	memcpy (hdr->id, "DSTR", 4);
	hdr->sr = 's';
	hdr->c = 0x12;	/* voice */
	hdr->dstar.b_bone.b_b.dest_repeater_id = 0x00;
	hdr->dstar.b_bone.b_b.send_repeater_id = 0x01;
	hdr->dstar.b_bone.b_b.send_terminal_id = 0x03;
}

void	send_reply (char buf[])
{
	char	reply_buf[10];

	memset (reply_buf, 0x00, 10);
	memcpy (reply_buf, buf, 6);
	reply_buf[6] = 'r';
	if (sendto (out_sd, reply_buf, 10, 0,
		gateway_out->ai_addr, gateway_out->ai_addrlen) < 0)
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s send reply error %s\n", 
			ctime(&cur_time), strerror(errno));
		fflush (log_file);
	}
}

void    area1_send_reply (char buf[])
{
        char    reply_buf[10];

        memset (reply_buf, 0x00, 10);
        memcpy (reply_buf, buf, 6);
        reply_buf[6] = 'r';
        if (sendto (out_sd, reply_buf, 10, 0,
		gateway_out->ai_addr, gateway_out->ai_addrlen) < 0)
        {
                time(&cur_time);
                fprintf (log_file, "%24.24s send reply error %s\n",
                        ctime(&cur_time), strerror(errno));
                fflush (log_file);
        }
}

void    area2_send_reply (char buf[])
{
        char    reply_buf[10];

        memset (reply_buf, 0x00, 10);
        memcpy (reply_buf, buf, 6);
        reply_buf[6] = 'r';
        if (sendto (out_sd, reply_buf, 10, 0,
		gateway_out->ai_addr, gateway_out->ai_addrlen) < 0)
        {
                time(&cur_time);
                fprintf (log_file, "%24.24s send reply error %s\n",
                        ctime(&cur_time), strerror(errno));
                fflush (log_file);
        }
}

void    area3_send_reply (char buf[])
{
        char    reply_buf[10];

        memset (reply_buf, 0x00, 10);
        memcpy (reply_buf, buf, 6);
        reply_buf[6] = 'r';
        if (sendto (out_sd, reply_buf, 10, 0,
		gateway_out->ai_addr, gateway_out->ai_addrlen) < 0)
        {
                time(&cur_time);
                fprintf (log_file, "%24.24s send reply error %s\n",
                        ctime(&cur_time), strerror(errno));
                fflush (log_file);
        }
}


int	cos_check(void)
{
	if (usb_control_msg(udev, 0xC0, GET_AD_STATUS, 0, 0, &status, 1, 100) < 0)
	{
		node_close();      /* node adapter down ? */
		return FALSE;
	}
	if (status & COS_OnOff) return TRUE;
	return FALSE;
}

int	htoi (const char *s)
{
	int n;

	if ( *s != '0' || !(*(s+1) != 'x' || *(s+1) != 'X') ) return 0;
    
	for (n=0,s+=2 ; *s ; s++)
	{
		if ( *s >= '0' && *s <= '9' ) 
		{
			n = 16 * n + (*s - '0');
		}
		else if ( *s >= 'a' && *s <= 'f' ) {
			n = 16 * n + ((*s - 'a') + 10);
		}
		else if ( *s >= 'A' && *s <= 'F' ) {
			n = 16 * n + ((*s - 'A') + 10);
		}
	}
    
	return n;
}

int	seq_check (void)
{
	if (recv_m == m)
	{
		m++;
		m &= 0xffff;
		return TRUE;
	}
	else if (recv_m == 1)
	{
		m = 1;
                time(&cur_time);
                fprintf (log_file, "%24.24s dsgwd restarted (sequence reset)\n", ctime(&cur_time));
                fflush (log_file);
		return TRUE;
	}
			
	return FALSE;
}

int	recv_check(void)
{
	time_t	a_time;
	time (&a_time);
	if (!recv_sw)
	{
		if ((a_time - send_time) >= 5) reset_gateway();
		return FALSE;
	}
	recv_sw = FALSE;
	return TRUE;
}

int     area1_seq_check (void)
{
        if (area1_recv_m == area1_m)
        {
                area1_m++;
                area1_m &= 0xffff;
                return TRUE;
        }
        return FALSE;
}

int     area1_recv_check(void)
{
        if (!area1_recv_sw) return FALSE;
        area1_recv_sw = FALSE;
        return TRUE;
}

int     area2_seq_check (void)
{
        if (area2_recv_m == area2_m)
        {
                area2_m++;
                area2_m &= 0xffff;
                return TRUE;
        }
        return FALSE;
}

int     area2_recv_check(void)
{
        if (!area2_recv_sw) return FALSE;
        area2_recv_sw = FALSE;
        return TRUE;
}

int     area3_seq_check (void)
{
        if (area3_recv_m == area3_m)
        {
                area3_m++;
                area3_m &= 0xffff;
                return TRUE;
        }
        return FALSE;
}

int     area3_recv_check(void)
{
        if (!area3_recv_sw) return FALSE;
        area3_recv_sw = FALSE;
        return TRUE;
}


void	printOnOff (char sw)
{
	if (sw) fprintf (log_file, "ON\n");
	else	fprintf (log_file, "OFF\n");
}

void    echo_header_send_set(void)
{
        unsigned short int      tmp;

        dv_pkt_set(&echo_dv_pkt);
        echo_dv_pkt.length[0] = 0x00;
        echo_dv_pkt.length[1] = 0x30;
        echo_dv_pkt.dstar.b_bone.b_b.id = 0x20;        /* voice */
        tmp = rand() & 0xffff;
        memcpy (echo_dv_pkt.dstar.b_bone.b_b.frame_id, &tmp, 2);
        echo_dv_pkt.dstar.b_bone.b_b.seq = 0x80;
}

void	putFifo (int len, struct dv_packet pkt)
{
	struct FifoPkt	*ret;

	ret = malloc (sizeof (struct FifoPkt));
	if (ret == NULL)
	{
		fprintf (log_file, "memory error\n");
		fflush (log_file);
		return;
	}
	ret->next = NULL;
	ret->length = len;
	memcpy (&ret->pkt, &pkt, len);
	Wp->next = ret;
	Wp = ret;
}

int	getFifo (int *len, struct dv_packet *pkt)
{
	struct	FifoPkt	*tmp;

	if (Rp->next == NULL) return FALSE;
	tmp = Rp;
	Rp = Rp->next;
	*len = Rp->length;
	memcpy (pkt, &Rp->pkt, Rp->length);
	free (tmp);
	return TRUE;
}

void    putArea1Fifo (int len, struct dv_packet pkt)
{
        struct FifoPkt  *ret;
        ret = malloc (sizeof (struct FifoPkt));
        if (ret == NULL)
        {
                fprintf (log_file, "memory error\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (&ret->pkt, &pkt, len);
        Area1Wp->next = ret;
        Area1Wp = ret;
}

int     getArea1Fifo (int *len, struct dv_packet *pkt)
{
        struct  FifoPkt *tmp;

        if (Area1Rp->next == NULL) return FALSE;
        tmp = Area1Rp;
        Area1Rp = Area1Rp->next;
        *len = Area1Rp->length;
        memcpy (pkt, &Area1Rp->pkt, Area1Rp->length);
        free (tmp);
        return TRUE;
}

void    putArea2Fifo (int len, struct dv_packet pkt)
{
        struct FifoPkt  *ret;
        ret = malloc (sizeof (struct FifoPkt));
        if (ret == NULL)
        {
                fprintf (log_file, "memory error\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (&ret->pkt, &pkt, len);
        Area2Wp->next = ret;
        Area2Wp = ret;
}

int     getArea2Fifo (int *len, struct dv_packet *pkt)
{
        struct  FifoPkt *tmp;

        if (Area2Rp->next == NULL) return FALSE;
        tmp = Area2Rp;
        Area2Rp = Area2Rp->next;
        *len = Area2Rp->length;
        memcpy (pkt, &Area2Rp->pkt, Area2Rp->length);
        free (tmp);
        return TRUE;
}

void    putArea3Fifo (int len, struct dv_packet pkt)
{
        struct FifoPkt  *ret;
        ret = malloc (sizeof (struct FifoPkt));
        if (ret == NULL)
        {
                fprintf (log_file, "memory error\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (&ret->pkt, &pkt, len);
        Area3Wp->next = ret;
        Area3Wp = ret;
}

int     getArea3Fifo (int *len, struct dv_packet *pkt)
{
        struct  FifoPkt *tmp;

        if (Area3Rp->next == NULL) return FALSE;
        tmp = Area3Rp;
        Area3Rp = Area3Rp->next;
        *len = Area3Rp->length;
        memcpy (pkt, &Area3Rp->pkt, Area3Rp->length);
        free (tmp);
        return TRUE;
}

void    putRespFifo (int len, char pkt[])
{
        struct RespFifoPkt  *ret;

        ret = malloc (sizeof (struct RespFifoPkt));
        if (ret == NULL)
        {
                fprintf (log_file, "memory error\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (&ret->pkt, pkt, len);
        RespWp->next = ret;
        RespWp = ret;
}

int     getRespFifo (int *len, char *pkt)
{
        struct  RespFifoPkt *tmp;
        if (RespRp->next == NULL) return FALSE;
        tmp = RespRp;
        RespRp = RespRp->next;
        *len = RespRp->length;
        memcpy (pkt, &RespRp->pkt, RespRp->length);
        free (tmp);
        return TRUE;
}

void	short_msg(struct echo *echo, char voice[])
{
	if ((voice[16] & 0x1f) % 2)
	{
		echo->mini_header = voice[26] ^ 0x70;
		echo->msg_tmp[0] = voice [27] ^ 0x4f;
		echo->msg_tmp[1] = voice [28] ^ 0x93;
	}
	else
	{
		echo->msg_tmp[2] = voice[26] ^ 0x70;
		echo->msg_tmp[3] = voice[27] ^ 0x4f;
		echo->msg_tmp[4] = voice[28] ^ 0x93;
		switch (echo->mini_header)
		{
			case 0x40:      // short message
				memcpy (&echo->msg[0], &echo->msg_tmp[0], 5);
				break;
			case 0x41:
				memcpy (&echo->msg[5], &echo->msg_tmp[0], 5);
				break;
			case 0x42:
				memcpy (&echo->msg[10], &echo->msg_tmp[0], 5);
				break;
			case 0x43:
				memcpy (&echo->msg[15], &echo->msg_tmp[0], 5);
				break;
		}
	}
}

enum {
	resp_set= 0,
	resp_wait,
	resp_send
} response_state = resp_set;

void	RespSend(void)
{
	int	len;
	struct	dv_header	dv_hdr;
	char	buff[64];
	struct	timeval	timer;
	struct	timeval temp1;
	struct	timeval	temp2;

	switch (response_state)
	{
		case resp_set:
			temp1.tv_sec = 0;
			temp1.tv_usec = 300000;
			timeradd (&resp_timer, &temp1, &temp2);
			resp_timer.tv_sec = temp2.tv_sec;
			resp_timer.tv_usec = temp2.tv_usec;
			response_state = resp_wait;
			break;
			
		case resp_wait:
			gettimeofday (&timer, NULL);
			if(timercmp(&timer, &resp_timer, >)) response_state = resp_send;
			break;
		
		case resp_send:
			if (getRespFifo(&len, buff))
			{
				buff[17] &= 0xbf;
				if (len == 58)
				{
					memcpy (&dv_hdr, &buff[17], 41);
        				if (!memcmp (&buff[20], node_area_rep_callsign, 8) && node_sw)
                			{

                        			/* frame ID check */
						//if (node_last_frame_sw)
						{
							memcpy (node_save_frame_id, &buff[14], 2);
							memcpy (dv_hdr.RPT2Call, &buff[28], 8);
							memcpy (dv_hdr.RPT1Call, &buff[20], 8);
                        				header_send(dv_hdr);
						}
        				}
                			else if (!memcmp (&buff[20], dvap_area_rep_callsign, 8) && dvap_sw)
                			{
         					/* frame ID check */
						//if (!dvap_last_frame_sw)
						{
							memcpy (dvap_save_frame_id, &buff[14], 2);
							memcpy (dv_hdr.RPT2Call, &buff[28], 8);
							memcpy (dv_hdr.RPT1Call, &buff[20], 8);
                        				header_send(dv_hdr);
						}
					}
  				}
                		else if ((len == 29) || (len == 32))
                		{
                        		if (!memcmp (node_save_frame_id, &buff[14], 2))
                        		{
                                		if (len == 29)
                                		{
                                        		if (buff[16] & 0x40)
                                        		{
                                                		memcpy (&buff[26], lastframe, 6);
                                                		node_last_send (&buff[17]);
                                                		memset (node_save_frame_id, 0x00, 2);
                                        		}
                                        		else  node_voice_send (&buff[17]);
                                		}
                                		else if (len == 32)
                                		{
                                        		memcpy (&buff[26], lastframe, 6);
                                        		node_last_send(&buff[17]);
                                        		memset (node_save_frame_id, 0x00, 2);
                                		}
                        		}
                        		else if (!memcmp (dvap_save_frame_id, &buff[14], 2))
                        		{
                                		gettimeofday(&InetInTime, NULL);
                                		if (debug) dvap_inet_pkt_cnt++;
                                		if (len == 29)
                                		{
                                        		if (buff[16] & 0x40)
                                        		{
                                                		memcpy (&buff[26], lastframe, 6);
                                                		dvap_last_send (&buff[17]);
                                                		memset (dvap_save_frame_id, 0x00, 2);
                                        		}
                                        		else  dvap_voice_send (&buff[17]);
                                		}
                                		else if (len == 32)
                                		{
                                        		memcpy (&buff[26], lastframe, 6);
                                        		dvap_last_send(&buff[17]);
                                        		memset (dvap_save_frame_id, 0x00, 2);
                                		}
                        		}
				}
				temp1.tv_sec = 0;
				temp1.tv_usec = 20000;
				timeradd (&resp_timer, &temp1, &temp2);
				resp_timer.tv_sec = temp2.tv_sec;
				resp_timer.tv_usec = temp2.tv_usec;
				response_state = resp_wait;
				break;
			}
			resp_ptt_off();
			response_state = resp_set;
			resp_timer.tv_sec = 0;
			resp_timer.tv_usec = 0;
			break;
	}
}
