#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<string.h>
#include	<sys/time.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<usb.h>
#include	<sys/utsname.h>
#include	<signal.h>
#include	<sys/select.h>
#include	<errno.h>
#include	<netdb.h>
#include	<time.h>
#include	<ctype.h>
#include	<fcntl.h>
#include	<termios.h>
#include	<linux/tty.h>
#include	<sys/ioctl.h>
#include	"config.h"
#include	"node.h"
#include	"dstar.h"

#define		CONFIG_FILE	"/opt/dv_repeater/etc/dv_repeater.conf"
#define		LOG_FILE	"/var/log/dv_repeater.log"
#define		PID_FILE	"/var/run/dv_repeater.pid"
#define		TRUE	1
#define		FALSE	0
#define		RECHECK	15

#define		DVAP_DEVICE	"/dev/dvap"
#define		DVAP_SPEED	B230400


void	print_PICinfo(void);
void    header_read_from_rig(void);
int	voice_read_from_rig(void);
void	last_frame_send(void);
void    header_send(struct dv_header header);
void    voice_send(char voice[]);
void	last_send(char	voice[]);
int	cos_check(void);
int     htoi (const char *s);
int	seq_check(void);
int	recv_check(void);
void	send_response(void);
void	header_send_set_from_rig(void);
void	printOnOff( char sw);
void    putFifo (int len, struct dv_packet pkt);
int     getFifo (int *len, struct dv_packet *pkt);
void	node_usb_init(void);
void	dvap_open(void);
void	dvap_close(void);
void	node_close (void);
void	node_term(void);
void    dv_pkt_set(struct dv_packet *hdr);
void	node_header_send (char header[]);
void	node_voice_send (char voice[]);
void	node_last_send (char voice[]);
void	dvap_header_send (char header[]);
void	dvap_voice_send (char voice[]);
void	dvap_last_send (char voice[]);

usb_dev_handle *udev;
union
{
	char	buffer[32];
	struct	dv_header	hdr;
} usb;
char	status;
int	CrcSW, Notice;
int	HeaderLength;
int	voice_pnt;
char	seq;
unsigned int	m;
unsigned int	recv_m;
int	recv_sw;
unsigned int	area1_m;
unsigned int	area1_recv_m;
int	area1_recv_sw;
unsigned int     area2_m;
unsigned int     area2_recv_m;
int     area2_recv_sw;
unsigned int     area3_m;
unsigned int     area3_recv_m;
int     area3_recv_sw;

struct	dv_packet	dv_pkt;
struct	dv_packet	node_pkt;
struct	dv_packet	dvap_pkt;
struct	dv_packet	echo_dv_pkt;
struct	dv_packet	reply_dv_pkt;
struct	dv_packet	posit;
struct	dv_packet	echo_posit;

int	in_sd;
int	out_sd;
int	monitor_sd;
int	area1_sd;
int	area2_sd;
int	area3_sd;

char	voice_temp[12];
char	voice_save[24];

char	node_area_rep_callsign[8];
char	area1_rep_callsign[8];
char	area2_rep_callsign[8];
char	area3_rep_callsign[8];
char	dvap_area_rep_callsign[8];
char	gateway_callsign[8];
char	sys_call[8];
char	echo_area_rep_callsign[8];
char	echo_server[8];

FILE	*log_file;
FILE	*pid_file;

int	debug;

struct utsname      uname_buf;
time_t	cur_time;
int	sig_term;
char	gateway_name[128];
char	area1_fqdn[128];
char	area2_fqdn[128];
char	area3_fqdn[128];
int	gateway_port;
int	area1_port;
int	area2_port;
int	area3_port;
int	listen_port;
int	repeater;
int	node_last_frame_sw;
int	dvap_last_frame_sw;
int	send_null_sw;
struct	dv_header	node_gw_resp;
struct	dv_header	dvap_gw_resp;
int	node_gw_resp_sw;
int	dvap_gw_resp_sw;
struct	timeval	dvap_in_time;

struct	addrinfo	hints;
struct	addrinfo	*gateway_in;
struct	addrinfo	*gateway_out;
struct	addrinfo	*monitor_out;
struct	addrinfo	*area1_in;
struct	addrinfo	*area1_out;
struct	addrinfo	*area2_in;
struct	addrinfo	*area2_out;
struct	addrinfo	*area3_in;
struct	addrinfo	*area3_out;
char	PORT[8];

struct	sockaddr_storage	in_addr;
socklen_t	in_addr_len;

struct	timeval		sys_timeout;
char		node_save_frame_id[2];
char		dvap_save_frame_id[2];
char		dvap_squelch_status;
int		monitor_port;
char		monitor_name[128];

struct	sockaddr_storage	mon_addr;
socklen_t			mon_addr_len;

struct  usb_bus *bus;
struct  usb_device      *dev;
int     dev_found;

struct	timeval	tm0, tm1;

union
{
	char	buf[2048];
	struct	dv_packet	buff_pkt;
} buf_pkt;

/* for pselect */
struct	timespec	tv;
fd_set  rfds;
fd_set	save_rfds;
sigset_t	sigset;
sigset_t	save_sigset;

struct	timeval	CosOffTime;
struct	timeval	InetInTime;
int	node_NoRespReply_sw;
int	dvap_NoRespReply_sw;
struct	dv_header	node_NoResp;
struct	dv_header	dvap_NoResp;
int	usb_read_cnt;
int	loop_cnt;

long	int	node_rig_pkt_cnt;
long	int	dvap_rig_pkt_cnt;
long	int	node_inet_pkt_cnt;
long	int	dvap_inet_pkt_cnt;
long	int	echo_pkt_cnt;

/* node adapter */
int	VenderID;
int	ProductID;

/* misc switch */

/* Jitter buffer */
struct	echo
{
	struct	echo	*next;
	long	int	in_cnt;
	long	int	out_cnt;
	struct	timeval	send_time;
	struct	timeval	EchoInTime;
	FILE	*tmp_file;
	int	echo_state;
	int	jitter_out_pnt;
	int	jitter_cnt;
	int	seq;
	char	jitter[21][12];
	char	callsign[8];
	char	frame_id[2];
	char	recv_seq;
	char	msg[20];
	char	mini_header;
	char	msg_tmp[5];
};

struct	echo	*echo_pnt;

int	send_echo_skip;

struct	FifoPkt
{
	struct	FifoPkt	*next;
	int	length;
	struct	dv_packet pkt;
};

struct	RespFifoPkt
{
	struct	RespFifoPkt *next;
	int	length;
	char	pkt[64];
};



struct	FifoPkt *Rp;
struct	FifoPkt *Wp;

struct	RespFifoPkt	*RespRp;
struct	RespFifoPkt	*RespWp;

struct	FifoPkt		*Area1Rp;
struct	FifoPkt		*Area1Wp;

struct  FifoPkt         *Area2Rp;
struct  FifoPkt         *Area2Wp;

struct  FifoPkt         *Area3Rp;
struct  FifoPkt         *Area3Wp;

int	init_sw;
int	dvap_voice_send_sw;
int	node_voice_send_sw;
int	rep_position_send_sw;
time_t	echo_position_send_interval;
time_t	echo_position_send_time;

int	dvap_fd;

time_t	dvap_keep_alive;

int	dvap_buff_pnt;
struct	timeval	dvap_InTime;

int	node_sw;
int	dvap_sw;
long	int	dvap_freq;
long	int	dvap_rx_freq;
long	int	dvap_tx_freq;
signed	char 	dvap_squelch;
short	int	dvap_calibration;
int	dvap_auto_calibration;
int	dvap_auto_calibration_set;
time_t	re_check;

time_t	send_time;
struct	timeval	resp_timer;
