<?php
// $Id: pdatheme.image.inc,v 1.1.2.7 2008/04/21 11:44:10 z0rac Exp $

function _pdatheme_show_image($id) {
  ob_end_clean();
  if ($cache = cache_get('pdatheme:'. $id)) {
    include_once PDATHEME_PATH .'/pdatheme.theme.inc';
    $data = unserialize($cache->data);
    $cc = _pdatheme_cache_control($_SERVER['HTTP_CACHE_CONTROL']);
    if (isset($cc['no-cache']) || $_SERVER['HTTP_PRAGMA'] == 'no-cache') {
      $data = array('url' => $data['url']);
    }
    if ((isset($cc['max-age']) && $cc['max-age'] == 0) || time() >= $data['expire']) {
      $image = strpos($data['url'], '://') ? _pdatheme_fetch_image($data) : _pdatheme_cache_image($data);
      cache_set('pdatheme:'. $id, 'cache', serialize($data));
    }
    $etag = md5($data['url'] . $data['cached']);
    if (_pdatheme_modified($data['cached'], $etag, $data['expire'])) {
      if (empty($image)) {
        if (isset($data['image'])) {
          $image = imagecreatefromstring($data['image']);
        }
        elseif (!strpos($data['url'], '://')) {
          $image = _pdatheme_image_load(_pdatheme_image_file($data['url']));
        }
      }
      if (!empty($image)) {
        _pdatheme_image_resize($image);
        _pdatheme_image_output($image, $data['cached'], $etag, $data['expire']);
      }
      header('HTTP/1.1 415 Unsupported Media Type');
    }
    exit();
  }
  header('HTTP/1.1 404 Not Found');
  exit();
}

function _pdatheme_fetch_image(&$data) {
  $headers = array();
  if (isset($data['etag'])) {
    $headers['If-None-Match'] = $data['etag'];
  }
  if (isset($data['modified'])) {
    $headers['If-Modified-Since'] = gmdate('D, d M Y H:i:s', $data['modified']) .' GMT';
  }
  $reqtime = time();
  $reply = drupal_http_request($data['url'], $headers);
  $date = _pdatheme_datetime($reply->headers['Date']);
  $age = max(isset($date) ? time() - $date : 0, (int)$reply->headers['Age']);
  if (isset($reply->redirect_code)) {
    $reply->code = $reply->redirect_code;
  }
  if (isset($reply->error)) {
    header('HTTP/1.1 '. (empty($reply->code) ? '504 Gateway Timeout' : ($reply->code < 0 ? '500 Internal Server Error' : $reply->code .' '. $reply->error)));
    exit();
  }
  if ($reply->code != 200 && $reply->code != 304) {
    header('HTTP/1.1 502 Bad Gateway');
    exit();
  }
  $image = NULL;
  $expire = _pdatheme_datetime($reply->headers['Expires']);
  $cc = _pdatheme_cache_control($reply->headers['Cache-Control'], array('private' => 'no-store', 's-maxage' => 'max-age'));
  if (!$cc && isset($expire) && $expire < $date) {
    $cc = array('no-store' => TRUE);
  }
  if ($reply->code == 200) {
    if ($image = imagecreatefromstring($reply->data) and !isset($cc['no-store'])) {
      if (_pdatheme_image_resize($image) and $encode = _pdatheme_image_encode($image)) {
        $reply->data = $encode;
      }
      if (isset($data['modified']) || $data['image'] != $reply->data) {
        $data['image'] = $reply->data;
        $data['cached'] = $reqtime;
      }
    }
    else {
      unset($data['image']);
      $data['cached'] = $reqtime;
    }
    $data['etag'] = $reply->headers['ETag'];
    $data['modified'] = _pdatheme_datetime($reply->headers['Last-Modified']);
    if (!isset($expire)) {
      $expire = $reqtime + min(max(($reqtime - $data['modified']) / 10, 900), 86400);
    }
  }
  elseif (isset($cc['no-store']) && isset($data['image'])) {
    $image = imagecreatefromstring($data['image']);
  }
  if (isset($cc['no-store'])) {
    unset($data['image'], $data['modified'], $data['etag']);
    $data['expire'] = FALSE;
  }
  elseif (isset($cc['no-cache']) || $reply->headers['Pragma'] == 'no-cache') {
    $data['expire'] = 0;
  }
  elseif (isset($cc['must-revalidate']) || isset($cc['proxy-revalidate'])) {
    $data['expire'] = 0;
  }
  elseif (isset($cc['max-age'])) {
    $data['expire'] = $reqtime + $cc['max-age'] - $age;
  }
  elseif (isset($expire)) {
    $data['expire'] = $expire;
  }
  return $image;
}

function _pdatheme_cache_image(&$data) {
  $image = NULL;
  $file = _pdatheme_image_file($data['url']);
  $mtime = filemtime($file);
  if ($mtime != $data['modified']) {
    unset($data['image']);
    if ($image = _pdatheme_image_load($file) and _pdatheme_image_resize($image)) {
      if ($encode = _pdatheme_image_encode($image)) {
        $data['image'] = $encode;
      }
    }
    $data['cached'] = time();
    $data['modified'] = $mtime;
  }
  return $image;
}

function _pdatheme_image_file($path) {
  if (file_exists($path) && file_check_location($path, '.')) {
    return $path;
  }
  if (strpos($path, 'system/files/') === 0 && variable_get('file_downloads', FILE_DOWNLOADS_PUBLIC) == FILE_DOWNLOADS_PRIVATE) {
    if ($file = file_create_path(substr($path, 13)) and file_exists($file)) {
      if (in_array(-1, module_invoke_all('file_download', $path))) {
        header('HTTP/1.1 403 Forbidden');
        exit();
      }
      return $file;
    }
  }
  header('HTTP/1.1 404 Not Found');
  exit();
}

function _pdatheme_image_load($file) {
  static $from = array(
    1 => 'imagecreatefromgif',
    2 => 'imagecreatefromjpeg',
    3 => 'imagecreatefrompng',
    15 => 'imagecreatefromwbmp',
    16 => 'imagecreatefromxbm'
  );
  if ($info = getimagesize($file) and isset($from[$info[2]])) {
    $func = $from[$info[2]];
    if (function_exists($func)) {
      return @$func($file);
    }
  }
}

function _pdatheme_image_resize(&$image) {
  if ($max = variable_get('pdatheme_image_max', 80)) {
    $sx = imagesx($image);
    $sy = imagesy($image);
    if ($sx > $max || $sy > $max) {
      if ($sx > $sy) {
        $x = $max; $y = max(intval($sy * $max / $sx), 1);
      }
      else {
        $x = max(intval($sx * $max / $sy), 1); $y = $max;
      }
      if (imageistruecolor($image)) {
        $rs = imagecreatetruecolor($x, $y);
        imagecopyresampled($rs, $image, 0, 0, 0, 0, $x, $y, $sx, $sy);
      }
      else {
        $rs = imagecreate($x, $y);
        imagepalettecopy($rs, $image);
        $bg = imagecolortransparent($image);
        if (is_integer($bg)) {
          imagefilledrectangle($rs, 0, 0, $x - 1, $y - 1, $bg);
          imagecopyresized($rs, $image, 0, 0, 0, 0, $x, $y, $sx, $sy);
          imagecolortransparent($rs, $bg);
        }
        else {
          imagecopyresized($rs, $image, 0, 0, 0, 0, $x, $y, $sx, $sy);
        }
      }
      $image = $rs;
      return TRUE;
    }
  }
  return FALSE;
}

function _pdatheme_image_encode($image) {
  foreach (array('png', imageistruecolor($image) ? 'jpeg' : 'gif') as $func) {
    $func = 'image'. $func;
    if (function_exists($func)) {
      ob_start();
      $func($image);
      return ob_get_clean();
    }
  }
  return NULL;
}

function _pdatheme_image_output($image, $mtime, $etag, $expire) {
  $accept = array();
  if (isset($_SERVER['HTTP_ACCEPT'])) {
    $accept = array_flip(explode(',', $_SERVER['HTTP_ACCEPT']));
  }
  foreach ((array)variable_get('pdatheme_image', array('gif', 'png', 'jpeg')) as $type) {
    $accept['image/'. $type] = TRUE;
  }
  $types = imageistruecolor($image) ? array('jpeg', 'png', 'gif') : array('png', 'gif', 'jpeg');
  foreach ($types as $type) {
    $func = 'image'. $type;
    if (isset($accept['image/'. $type]) && function_exists($func)) {
      header('Content-Type: image/'. $type);
      _pdatheme_cache_header($mtime, $etag, $expire);
      $func($image);
      exit();
    }
  }
}

function _pdatheme_image_url($url) {
  global $base_url;
  $rel = $url;
  foreach (array($base_url .'/', base_path()) as $base) {
    if (strpos($url, $base) === 0) {
      $rel = substr($url, strlen($base));
      break;
    }
  }
  if (strncmp($rel, 'pdatheme/', 9)) {
    if ($rel != $url || variable_get('pdatheme_image_proxy', 0)) {
      $id = md5($rel);
      $cache = cache_get('pdatheme:'. $id);
      if (!$cache || !isset($cache->data['url']) || $cache->data['url'] != $rel) {
        cache_set('pdatheme:'. $id, 'cache', serialize(array('url' => $rel)));
      }
      return base_path() .'pdatheme/'. $id;
    }
  }
  return $url;
}
