<?php
// $Id: pdatheme.theme.inc,v 1.1.2.7 2008/04/21 11:44:10 z0rac Exp $

function _pdatheme_cache($id, $data = NULL) {
  global $user, $base_root;
  static $caching = TRUE;
  if ($caching && !$user->uid && $_SERVER['REQUEST_METHOD'] == 'GET') {
    $cid = $id .':'. $base_root . request_uri();
    if (isset($data)) {
      cache_set($cid, 'cache_page', $data, CACHE_TEMPORARY, drupal_get_headers());
      $cache = cache_get($cid, 'cache_page');
      _pdatheme_cache_header($cache->created, md5($cid . $cache->created));
      header('Content-Length: '. strlen($cache->data));
    }
    elseif (count(drupal_set_message()) == 0) {
      if ($cache = cache_get($cid, 'cache_page')) {
        require_once './includes/module.inc';
        $etag = md5($cid . $cache->created);
        bootstrap_invoke_all('init');
        if (_pdatheme_modified($cache->created, $etag)) {
          foreach (explode("\n", $cache->headers) as $header) {
            header($header);
          }
          _pdatheme_cache_header($cache->created, $etag);
          header('Content-Length: '. strlen($cache->data));
          print $cache->data;
        }
        bootstrap_invoke_all('exit');
        exit();
      }
    }
    else {
      $caching = FALSE;
    }
  }
}

function _pdatheme_cache_header($mtime, $etag, $expire = NULL) {
  if (isset($mtime)) {
    header('Last-Modified: '. gmdate('D, d M Y H:i:s', $mtime) .' GMT');
  }
  header('ETag: "'. $etag .'"');
  if ($expire !== FALSE) {
    $now = time();
    $age = isset($expire) ? $expire - $now : 300;
    if ($age > 0) {
      header('Expires: '. gmdate('D, d M Y H:i:s', $now + $age) .' GMT');
      header('Cache-Control: max-age='. $age);
    }
    else {
      header("Expires: Sun, 19 Nov 1978 05:00:00 GMT");
      header('Cache-Control: must-revalidate');
    }
  }
  else {
    header("Expires: Sun, 19 Nov 1978 05:00:00 GMT");
    header('Cache-Control: no-cache,must-revalidate');
    header('Pragma: no-cache');
  }
}

function _pdatheme_cache_control($header, $copy = array()) {
  $cc = array();
  if ($header != '') {
    foreach (explode(',', $header) as $item) {
      list($item, $value) = explode('=', $item);
      $cc[trim($item)] = isset($value) ? trim($value) : TRUE;
    }
    foreach ($copy as $from => $to) {
      if (isset($cc[$from])) {
        $cc[$to] = $cc[$from];
      }
    }
  }
  return $cc;
}

function _pdatheme_modified($mtime, $etag, $expire = NULL) {
  $match = FALSE;
  if (isset($_SERVER['HTTP_IF_NONE_MATCH'])) {
    $qt = '"'. $etag .'"';
    foreach (explode(',', stripslashes($_SERVER['HTTP_IF_NONE_MATCH'])) as $tag) {
      $tag = trim($tag);
      if ($tag == '*' || $tag == $qt || $tag == 'W/'. $qt) {
        $match = TRUE;
        break;
      }
    }
    if (!$match) {
      return TRUE;
    }
  }
  if (!$match || isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
    if ($mtime != _pdatheme_datetime(stripslashes($_SERVER['HTTP_IF_MODIFIED_SINCE']))) {
      return TRUE;
    }
  }
  header('HTTP/1.1 304 Not Modified');
  _pdatheme_cache_header(NULL, $etag, $expire);
  return FALSE;
}

function _pdatheme_datetime($hdr) {
  if ($hdr != '') {
    $time = FALSE;
    if (preg_match('/^\s*[a-z]+,\s*\d+(\s+|-)[a-z]+(\s+|-)\d+\s+\d+:\d+:\d+\s+\w+/i', $hdr, $m)) {
      $time = strtotime($m[0]);
    }
    elseif (preg_match('/^\s*[a-z]+\s+[a-z]+\s+\d+\s+\d+:\d+:\d+\s+\d+\b/i', $hdr, $m)) {
      $time = strtotime($m[0] .' GMT');
    }
    if ($time !== FALSE && $time >= 0) {
      return $time;
    }
  }
  return NULL;
}
