<?php
// $Id: xhtml.inc,v 1.3 2008/04/03 09:57:00 z0rac Exp $

function _pda_doctype() {
  return '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">';
}

function _pda_page($title, $body, $meta = array()) {
  global $locale;
  $output = '<?xml version="1.0" encoding="'. _pda_charset_mime_name() .'"?>'. _pda('doctype');
  $output .= '<html xmlns="http://www.w3.org/1999/xhtml" lang="'. $locale .'" xml:lang="'. $locale .'"><head>';
  foreach ($meta as $attrib) {
    $output .= '<meta'. drupal_attributes($attrib) .' />';
  }
  $output .= drupal_set_html_head() . drupal_get_css();
  $output .= '<title>'. implode(' | ', $title) .'</title>';
  $output .= '</head>'. $body .'</html>';

  return _pda_xhtml_output(_pda_xhtml_replace(_pda_xhtml_parse($output, TRUE), '_pda_replace'));
}

function _pda_replace($tag) {
  if ($tag[0] == 'a' && isset($tag[1]['id'])) {
    $tag[1]['name'] = $tag[1]['id'];
    unset($tag[1]['id']);
  }
  unset($tag[1]['title']);
  return $tag;
}

function _pda_body($content, $show_blocks = TRUE, $show_messages = TRUE) {
  $home = drupal_is_front_page();
  $output = '<body>';
  if ($home) {
    $output .= '<div id="header">';
    if (theme_get_setting('toggle_name') and $sitename = variable_get('site_name', 'Drupal')) {
      $output .= '<h1>'. check_plain($sitename) .'</h1>';
    }
    if (theme_get_setting('toggle_logo') and $logo = theme_get_setting('logo')) {
      $output .= '<img src="'. check_url($logo) .'" alt="" />';
    }
    if (theme_get_setting('toggle_slogan') and $slogan = variable_get('site_slogan', '')) {
      $output .= '<h5>'. check_plain($slogan) .'</h5>';
    }
    if ($mission = filter_xss_admin(theme_get_setting('mission'))) {
      $output .= '<marquee>'. $mission .'</marquee>';
    }
    if ($show_blocks) {
      $output .= theme('blocks', 'header');
    }
    $output .= '</div>';
  }
  if ($show_blocks) {
    $output .= theme('blocks', 'top_content');
  }
  if ($title = drupal_get_title()) {
    $output .= '<h2 class="header">'. $title .'</h2>';
  }
  $output .= theme('menu_local_tasks') . theme('help');
  if ($show_messages) {
    $output .= theme('status_messages');
  }
  $output .= $content;
  if ($show_blocks) {
    $output .= theme('blocks', 'bottom_content');
    if ($home) {
      $output .= theme('blocks', 'footer');
    }
  }
  $output .= _pda('primary_links');
  if (!$home) {
    $output .= theme('breadcrumb', drupal_get_breadcrumb());
  }
  elseif ($footer = variable_get('site_footer', '')) {
    $output .= '<div id="footer">'. $footer .'</div>';
  }
  $output .= theme('closure') .'</body>';

  return $output;
}

function _pda_primary_links() {
  $output = '';
  foreach (array(menu_primary_links(), menu_secondary_links()) as $links) {
    if ($links) {
      if ($output) {
        $output .= theme('links', $links);
      }
      else {
        $items = _pda_encode_links($links);
        $i = 1;
        foreach ($items as $key => $item) {
          $items[$key] = $i < 10 ? _pda_accesskey($i++, $item) : _pda('icon') . $item;
        }
        $output = '<div>'. implode('</div><div>', $items) .'</div>';
      }
    }
  }
  if ($output) {
    return '<div id="menu">'. $output .'</div>';
  }
}

// from theme.inc
function pda_links($links, $attributes = NULL) {
  if ($links) {
    return '<div class="links">'. implode(' | ', _pda_encode_links($links)) .'</div>';
  }
}

function pda_breadcrumb($breadcrumb) {
  if ($breadcrumb) {
    return _pda_accesskey('0', implode(' > ', $breadcrumb));
  }
}

function pda_node($node, $teaser = FALSE, $page = FALSE) {
  $output = '<div class="node">';
  if (!$page) {
    $output .= '<h2 class="title">'. ($teaser ? l($node->title, 'node/'. $node->nid) : check_plain($node->title)) .'</h2>';
  }
  if (theme_get_setting('toggle_node_info_'. $node->type)) {
    $output .= _pda('author', theme('username', $node), $node->created);
  }
  $output .= $teaser ? truncate_utf8(strip_tags($node->teaser), 150, FALSE, TRUE) : $node->body;
  $links = array();
  if (module_exists('taxonomy')) {
    $links = taxonomy_link('taxonomy terms', $node);
  }
  if (!$teaser && !empty($node->links)) {
    $links = array_merge($links, $node->links);
  }
  $output .= theme('links', $links) .'</div>';
  return $output;
}

function pda_block($block) {
  $output  = '<div class="block" id="block-'. $block->module .'-'. $block->delta .'">';
  $output .= '<h2 class="title">'. $block->subject .'</h2>';
  $output .= '<div class="content">'. $block->content .'</div>';
  $output .= '</div>';
  return $output;
}

function pda_closure($main = 0) {
  $footer = module_invoke_all('footer', $main);
  return implode('', $footer);
}

// from pager.inc
function pda_pager($tags = array(), $limit = 10, $element = 0, $parameters = array()) {
  global $pager_total;

  if ($pager_total[$element] > 1) {
    $links = array();
    $links[] = theme('pager_first', '|<', $limit, $element, $parameters);
    $links[] = theme('pager_previous', '<', $limit, $element, 1, $parameters);
    $links[] = theme('pager_list', $limit, $element, ($tags[2] ? $tags[2] : 9), '', $parameters);
    $links[] = theme('pager_next', '>', $limit, $element, 1, $parameters);
    $links[] = theme('pager_last', '>|', $limit, $element, $parameters);
    return '<div class="pager">'. strip_tags(implode('', array_diff($links, array(''))), '<a>') .'</div>';
  }
}

function pda_pager_link() {
  $args = func_get_args();
  return ' '. call_user_func_array('theme_pager_link', $args) .' ';
}

// book
function pda_book_navigation($node) {
  $output = '';
  if ($node->nid) {
    if ($tree = book_tree($node->nid)) {
      $output .= '<div class="book-menu">'. $tree .'</div>';
    }
    $output .= '<div class="book-links">';
    $output .= ($prev = book_prev($node)) ? l(t('< prev'), 'node/'. $prev->nid) : t('< prev');
    $output .= ' | '. ($node->parent ? l(t('up'), 'node/'. $node->parent) : t('up')) .' | ';
    $output .= ($next = book_next($node)) ? l(t('next >'), 'node/'. $next->nid) : t('next >');
    $output .= '</div>';
  }
  return $output;
}

// comment
function pda_comment($comment, $links = array()) {
  $output = '<div class="comment'. ($comment->status == COMMENT_NOT_PUBLISHED ? ' comment-unpublished' : '') .'">';
  $output .= l($comment->subject, $_GET['q'], NULL, NULL, 'comment-'. $comment->cid) . theme('mark', $comment->new);
  $output .= _pda('author', theme('username', $comment), $comment->timestamp);
  $output .= $comment->comment . theme('links', $links);
  $output .= '</div>';
  return $output;
}

// trackback
function pda_trackback($trackback, $links = array()) {
  $output = '<div class="trackback" id="trackback-'. $trackback->trid .'">';
  $output .= l($trackback->subject, $trackback->url);
  $output .= _pda('author', theme('placeholder', $trackback->name), $trackback->created);
  $output .= check_markup($trackback->excerpt) . theme('links', $links);
  $output .= '</div>';
  return $output;
}

function pda_trackback_url($url) {
}

function _pda_author($author, $date = NULL) {
  $items = array();
  if ($author != '') {
    $items[] = $author;
  }
  if (isset($date)) {
    $items[] = theme('placeholder', format_date($date, 'small'));
  }
  return '<ul class="author"><li>'. implode('</li><li>', $items) .'</li></ul>';
}
