<?php
// $Id: pda.css.inc,v 1.1 2007/10/01 15:27:29 z0rac Exp $

function _pda_css_head($head) {
  $rule = array();
  $xhtml = _pda_xhtml_parse($head, TRUE);
  while (list($k, $v) = each($xhtml)) {
    if (is_array($v)) {
      if ($v[0] == 'style' && isset($v[1]['type']) && $v[1]['type'] == 'text/css') {
        if (!isset($v[1]['media']) || $v[1]['media'] == 'all' || $v[1]['media'] == 'handheld') {
          if (list($k, $v) = each($xhtml) and is_string($v)) {
            $rule = _pda_css_parse($v, NULL, $rule);
          }
        }
      }
    }
  }
  return $rule;
}

function _pda_css_import($url, $file = NULL, $rule = array()) {
  global $base_url, $base_path;
  if ($url[0] == '/') {
    $n = strlen($base_path);
    $file = strncmp($url, $base_path, $n) ? NULL : ('./'. substr($url, $n));
  }
  elseif (preg_match('/^[a-z]+:/', $url)) {
    $n = strlen($base_url);
    $file = strncmp($url, $base_url, $n) ? NULL : ('.'. substr($url, $n));
  }
  else {
    $file = ($file != '' ? dirname($file) : '.') .'/'. $url;
  }
  return $file != '' ? _pda_css_parse(@file_get_contents($file), $file, $rule) : $rule;
}

function _pda_css_parse($css, $file = NULL, $rule = array()) {
  if ($file !== FALSE) {
    $css = preg_replace('@(("|\')(?:\\\\.|[^\\\\]+)*\2)|//.*$|/\*.*\*/@Ums', '$1', $css);
    preg_match_all('/\s*@(\w+(?:\s*,\s*\w+)*)\s*(?:
      ({(((("|\')(?:(?:\\\\.|[^\\\\]+?)*?)\6|[^{}"\']*?)*?|(?2))*)})|
      ((?:("|\')(?:(?:\\\\.|[^\\\\]+?)*?)\8|.*?)*);
      )|.*/Ssx', $css, $at, PREG_SET_ORDER);
    $css = '';
    $head = 1;
    foreach ($at as $at) {
      if (isset($at[7])) {
        if ($head && strcasecmp($at[1], 'import') == 0) {
          if (preg_match('/URL\(\s*((?:\\\\.|[^\\\\"\']+)+)\s*\)|("|\')((?:\\\\.|[^\\\\]+)+)\2/Usi', $at[7], $url)) {
            $url = preg_replace('/\\\\(.)/s', '$1', $url[1] != '' ? $url[1] : $url[3]);
            $rule = _pda_css_import($url, $file, $rule);
          }
        }
        continue;
      }
      $head = 0;
      if (isset($at[1])) {
        foreach (explode(',', strtolower($at[1])) as $n) {
          $n = trim($n);
          if ($n == 'all' || $n == 'handheld') {
            $rule = _pda_css_parse($at[3], FALSE, $rule);
            break;
          }
        }
      }
      else {
        $css .= $at[0];
      }
    }
  }
  preg_match_all('/(.*){((?:("|\')(?:(?:\\\\.|[^\\\\]+)*)\3|.*)*)}/Us', $css, $block, PREG_SET_ORDER);
  foreach ($block as $block) {
    $block[2] = preg_replace('/(?:("|\')([^\\\\]+)\1|(("|\')(?:\\\\.|[^\\\\]+)*\4))/SUs', '\2\3', $block[2]);
    preg_match_all('/\s*?(.*)\s*:\s*?((?:("|\')(?:\\\\.|[^\\\\]+)*\3|.*)*)\s*(?:;|$)/Us', $block[2], $pair, PREG_SET_ORDER);
    $prop = array();
    foreach ($pair as $pair) {
      if ($pair[1] != '' && $pair[2] != '') {
        $prop[strtolower($pair[1])] = $pair[2];
      }
    }
    foreach (explode(',', $block[1]) as $sel) {
      preg_match_all('/\s*(.+?)\s*(>|\+|\s|$)/', $sel, $sel, PREG_SET_ORDER);
      $context = array();
      foreach ($sel as $sel) {
        $class = explode('.', $sel[1]);
        list($tag, $id) = explode('#', array_shift($class), 2);
        $sel = trim($sel[2]) ? array('op' => $sel[2]) : array();
        if ($tag != '' && $tag != '*') {
          $sel['tag'] = $tag;
        }
        if (isset($id) && $id != '') {
          $sel['id'] = $id;
        }
        if ($class) {
          $sel['class'] = count($class) > 1 ? $class : $class[0];
        }
        $context[] = $sel;
      }
      $sel = array_pop($context);
      if (!isset($sel['op'])) {
        $k = isset($sel['tag']) ? $sel['tag'] : '*';
        if (isset($sel['id'])) {
          $k .= '#'. $sel['id'];
        }
        if (!isset($rule[$k])) {
          $rule[$k] = array();
        }
        if (isset($sel['class'])) {
          $class = array('class' => $sel['class']);
          if ($context) {
            $class['context*'] = array(array('context' => $context, 'prop' => $prop));
          }
          else {
            $class['prop'] = $prop;
          }
          if (!isset($rule[$k]['class*'])) {
            $rule[$k]['class*'] = array();
          }
          $rule[$k]['class*'][] = $class;
        }
        elseif ($context) {
          if (!isset($rule[$k]['context*'])) {
            $rule[$k]['context*'] = array();
          }
          $rule[$k]['context*'][] = array('context' => $context, 'prop' => $prop);
        }
        else {
          $rule[$k]['prop'] = isset($rule[$k]['prop']) ? array_merge($rule[$k]['prop'], $prop) : $prop;
        }
      }
    }
  }
  return $rule;
}

function _pda_css_expand($xhtml, $rule) {
  $stack = array();
  foreach ($xhtml as $key => $elem) {
    if (is_array($elem)) {
      if ($elem[0][0] != '/') {
	$tag = array(
          'name' => $elem[0],
	  'id' => isset($elem[1]['id']) ? $elem[1]['id'] : '',
	  'class' => array(),
	  'open' => empty($elem[2])
	);
	if (isset($elem[1]['class'])) {
	  foreach (array_diff(explode(' ', $elem[1]['class']), array('')) as $class) {
	    $tag['class'][$class] = TRUE;
	  }
	}
	$props = $class = $context = array();
	$suffix = $tag['id'] != '' ? array('', '#'. $tag['id']) : array('');
	foreach ($suffix as $suffix) {
	  foreach (array('*', $tag['name']) as $name) {
	    $k = $name . $suffix;
	    if (isset($rule[$k])) {
	      $c = $rule[$k];
	      if (isset($c['prop'])) {
		$props = _pda_css_merge_props($props, $c['prop']);
	      }
	      if (isset($c['context*'])) {
		$context = array_merge($context, $c['context*']);
	      }
	      if ($tag['class'] && isset($c['class*'])) {
		$class = array_merge($class, $c['class*']);
	      }
	    }
	  }
	}
	foreach ($class as $class) {
          if (is_array($class['class'])) {
            foreach ($class['class'] as $k) {
              if (!isset($tag['class'][$k])) {
                unset($class);
                break;
              }
            }
	  }
          elseif (!isset($tag['class'][$class['class']])) {
            unset($class);
          }
	  if (isset($class)) {
	    if (isset($class['prop'])) {
	      $props = _pda_css_merge_props($props, $class['prop']);
	    }
	    if (isset($class['context*'])) {
	      $context = array_merge($context, $class['context*']);
	    }
	  }
	}
	foreach ($context as $context) {
	  if (_pda_css_match_context($stack, $context['context'])) {
	    $props = _pda_css_merge_props($props, $context['prop']);
	  }
	}
	if ($props) {
	  $style = array();
	  foreach ($props as $k => $v) {
	    $style[] = $k .':'. $v;
	  }
	  $elem[1]['style'] = htmlspecialchars(implode(';', $style), ENT_QUOTES);
	}
	unset($elem[1]['class']);
	$xhtml[$key] = $elem;
	$stack[] = $tag;
      }
      else {
	$name = substr($elem[0], 1);
	while ($tag = array_pop($stack)) {
	  if ($tag['name'] == $name) {
	    $tag['open'] = FALSE;
	    $stack[] = $tag;
	    break;
	  }
	}
      }
    }
  }
  return $xhtml;
}

function _pda_css_match($tag, $cond) {
  if (isset($cond['tag']) && $cond['tag'] != $tag['name']) {
    return FALSE;
  }
  if (isset($cond['id']) && $tag['id'] != $cond['id']) {
    return FALSE;
  }
  if (isset($cond['class'])) {
    $value = $cond['class'];
    if (is_array($value)) {
      foreach ($value as $value) {
        if (!isset($tag['class'][$value])) {
          return FALSE;
        }
      }
    }
    elseif (!isset($tag['class'][$value])) {
      return FALSE;
    }
  }
  return TRUE;
}

function _pda_css_match_context($stack, $context) {
  if (count($context) > count($stack)) {
    return FALSE;
  }
  while ($cond = array_pop($context)) {
    if (isset($cond['op'])) {
      switch ($cond['op']) {
        case '+':
          $tag = array_pop($stack);
          if (!$tag || $tag['open'] || !_pda_css_match($tag, $cond)) {
            return FALSE;
          }
          break;

        case '>':
          while ($tag = array_pop($stack)) {
            if ($tag['open']) {
              break;
            }
          }
          if (!$tag || !_pda_css_match($tag, $cond)) {
            return FALSE;
          }
          break;

        default:
          return FALSE;
      }
    }
    else {
      do {
        while ($tag = array_pop($stack)) {
          if ($tag['open']) {
            break;
          }
        }
        if (!$tag) {
          return FALSE;
        }
      } while (!_pda_css_match($tag, $cond) || !_pda_css_match_context($stack, $context));
    }
  }
  return TRUE;
}

function _pda_css_merge_props($props, $add) {
  if ($add) {
    if ($props) {
      static $group = array(
        'background',
	'padding',
	'margin',
	'border',
	'border-top',
	'border-right',
	'border-bottom',
	'border-left',
	'list-style'
      );
      foreach ($group as $prop) {
	if (isset($add[$prop])) {
	  $k = $prop .'-';
	  $n = strlen($k);
	  foreach (array_keys($props) as $key) {
	    if (strncmp($key, $k, $n) == 0) {
	      unset($props[$key]);
	    }
	  }
	}
      }
      foreach (array('style', 'color', 'width') as $attr) {
	if (isset($add['border-'. $attr])) {
	  unset($props['border-top-'. $attr]);
	  unset($props['border-right-'. $attr]);
	  unset($props['border-bottom-'. $attr]);
	  unset($props['border-left-'. $attr]);
	}
      }
      $props = array_merge($props, $add);
    }
    else {
      $props = $add;
    }
  }
  return $props;
}
