<?php
// $Id: locale_ex.modules.inc,v 1.1.4.9 2008/01/31 17:20:22 z0rac Exp $

/*
 * Page handler for the localization of modules screen
 */
function locale_ex_modules(&$form_state) {
  $options = array();
  foreach (array('profiles', 'themes', 'modules') as $type) {
    $projects = call_user_func('_locale_ex_collect_'. $type);
    $form[$type] = array('#type' => 'value', '#value' => $projects);
    foreach ($projects as $key => $files) {
      $name = count($files) > 1 ? basename($key) : key($files);
      $options[$key] = isset($files[$name]['name']) ? $files[$name]['name'] : $name;
    }
  }
  $form['project'] = array(
    '#type' => 'radios',
    '#default_value' => key($options),
    '#options' => $options
  );
  $languages = locale_language_list();
  unset($languages['en']);
  if ($languages) {
    $form['langcode'] = array(
      '#type' => 'select',
      '#title' => t('Language name'),
      '#default_value' => key($languages),
      '#options' => array('' => t('<none>')) + $languages,
      '#description' => t('Select the language you would like to export in gettext Portable Object (.po) format. If you select <em>&lt;none&gt;</em>, a gettext Portable Object Template (.pot) file will be generated.')
    );
  }
  $form['buttons']['submit'] = array('#type' => 'submit', '#value' => t('Extract'));
  $form['buttons']['validate'] = array('#type' => 'submit', '#value' => t('Validate'));
  return $form;
}

function _locale_ex_collect_profiles() {
  $profiles = array();
  $profiles['/']['/'] = array(
    'name' => 'Drupal',
    'description' => t('Drupal core system.')
  );
  $files = file_scan_directory('profiles', '.+\.profile$', array('.', '..', 'CVS'), 0, TRUE, 'name', 1);
  ksort($files);
  foreach ($files as $file) {
    $key = dirname($file->filename);
    $profiles[$key][$file->name] = array(
      'description' => t('Installation profile %name.', array('%name' => $file->name))
    );
  }
  return $profiles;
}

function _locale_ex_collect_themes() {
  $themes = array();
  $files = drupal_system_listing('\.info$', 'themes');
  $engines = drupal_system_listing('\.engine$', 'themes/engines');
  ksort($files);
  foreach ($files as $name => $file) {
    if ($info = drupal_parse_info_file($file->filename)) {
      if (preg_match('"^(?:[^/]*/)*?themes/[^/]+"', $file->filename, $path)) {
        if (isset($info['description']) && $info['description'] != '') {
          $info['description'] = t($info['description']);
        }
        $themes[$path[0]][$name] = $info;
      }
    }
  }
  ksort($engines);
  foreach ($engines as $name => $file) {
    if (preg_match('"^(?:[^/]*/)*?themes/engines/[^/]+"', $file->filename, $path)) {
      $themes[$path[0]][$name] = array(
        'description' => theme('placeholder', dirname($file->filename))
      );
    }
  }
  return $themes;
}

function _locale_ex_collect_modules() {
  $modules = array();
  $files = drupal_system_listing('\.module$', 'modules', 'name', 0);
  ksort($files);
  foreach ($files as $file) {
    if ($info = drupal_parse_info_file(dirname($file->filename) .'/'. $file->name .'.info')) {
      if (preg_match('"^(?:[^/]*/)*?modules/[^/]+"', $file->filename, $path)) {
        if (isset($info['description']) && $info['description'] != '') {
          $info['description'] = t($info['description']);
        }
        $modules[$path[0]][$file->name] = $info;
      }
    }
  }
  $form['modules'] = array('#type' => 'value', '#value' => $modules);
  return $modules;
}

/*
 * Process the localization of modules submissions.
 */
function locale_ex_modules_submit($form_id, &$form_state) {
  $values = $form_state['values'];
  if ($project = $values['project']) {
    $installer = FALSE;
    if (isset($values['profiles'][$project])) {
      if ($project == '/') {
        $files = _locale_ex_core_files();
        $name = 'drupal';
      }
      else {
        $ext = 'php|inc|profile|module|engine|theme|install';
        $files = _locale_ex_grab($project, $ext) + _locale_ex_core_files($ext);
        $name = basename($project);
        $installer = TRUE;
      }
    }
    elseif (isset($values['themes'][$project])) {
      $files = _locale_ex_grab($project);
      $name = basename($project);
    }
    elseif (isset($values['modules'][$project])) {
      if (!is_file($project)) {
        $files = _locale_ex_grab($project);
        $name = basename($project);
        if ($name == 'system') {
          $files += _locale_ex_core_files(NULL, 'info');
        }
      }
      else {
        $dir = dirname($project);
        $files = array($project => TRUE);
        $name = basename($project, '.module');
        foreach (array('install', 'info') as $suffix) {
          $file = "$dir/$project.$suffix";
          if (file_exists($file)) {
            $files[$file] = TRUE;
          }
        }
      }
    }
    if ($files = array_keys($files)) {
      module_load_include('inc', 'locale_ex', 'locale_ex.extract');
      if ($values['op'] == $values['submit']) {
        _locale_ex_extract_export($name, $files, $installer, $values['langcode']);
        exit;
      }
      _locale_ex_extract_verify($name, $files, $installer, $values['langcode']);
    }
    $form_state['redirect'] = FALSE;
  }
}

function theme_locale_ex_modules($form) {
  foreach ($form['modules']['#value'] as $key => $modules) {
    $name = basename($key);
    $info = isset($modules[$name]) ? $modules[$name] : current($modules);
    $packages[!empty($info['package']) ? $info['package'] : 'Other'][$key] = $modules;
  }
  ksort($packages);
  $output .= _locale_ex_package_table($form, $form['profiles']['#value']);
  $output .= _locale_ex_package_table($form, $form['themes']['#value'], t('Themes of this project'), t('Themes'));
  foreach ($packages as $name => $modules) {
    $output .= _locale_ex_package_table($form, $modules, t('Modules of this project'), t($name));
  }
  $output .= drupal_render($form);
  return $output;
}

function _locale_ex_package_table(&$form, $package, $title = '', $name = NULL) {
  $collapsed = isset($name);
  $value = $form['project']['#value'] != '/' ? $form['project']['#value'] : '';
  $rows = array();
  foreach ($package as $key => $project) {
    $desc = '';
    if (count($project) > 1) {
      foreach ($project as $info) {
        $desc .= '<dt>'. $info['name'] .'</dt>';
        $desc .= '<dd><div class="description">'. $info['description'] .'</div></dd>';
      }
      $fieldset = array(
        '#title' => $title,
        '#collapsible' => TRUE,
        '#collapsed' => $key != $value,
        '#value' => '<dl>'. $desc .'</dl>'
      );
      $desc = theme('fieldset', $fieldset);
      $info = basename($key);
    }
    else {
      $info = key($project);
    }
    if (isset($project[$info]) && isset($project[$info]['description'])) {
      $desc = '<div class="description">'. $project[$info]['description'] .'</div>'. $desc;
    }
    if ($collapsed) {
      if ($value) {
        $collapsed = ($key != $value);
      }
      elseif (isset($form['modules']['#value'][$key])) {
        if (!isset($project[$info])) {
          $info = key($project);
        }
        $collapsed = ($project[$info]['project'] == 'drupal');
      }
    }
    $rows[] = array(drupal_render($form['project'][$key]), $desc);
  }
  $output = theme('table', array(t('Name'), t('Description')), $rows, array('class' => 'package'));
  if (isset($name)) {
    $fieldset = array(
      '#title' => $name,
      '#collapsible' => TRUE,
      '#collapsed' => $collapsed,
      '#value' => $output
    );
    $output = theme('fieldset', $fieldset);
  }
  return $output;
}

function _locale_ex_grab($dir, $ext = NULL) {
  if (!isset($ext)) {
    $ext = 'php|inc|module|engine|theme|install|info|profile|js';
  }
  return file_scan_directory($dir, '.+\.('. $ext .')$');
}

/*
 * Make list of Drupal's core files.
 */
function _locale_ex_core_files($ext = NULL, $mod = NULL) {
  static $modules = array(
    'aggregator', 'block', 'blog', 'blogapi', 'book', 'color', 'comment', 'contact', 'dblog',
    'filter', 'forum', 'help', 'locale', 'menu', 'node', 'openid', 'path', 'php', 'ping',
    'poll', 'profile', 'search', 'statistics', 'syslog', 'system', 'taxonomy', 'throttle',
    'tracker', 'translation', 'trigger', 'update', 'upload', 'user'
  );
  static $themes = array(
    'bluemarine', 'chameleon', 'garland', 'pushbutton', 'engines/phptemplate'
  );
  $files = array();
  foreach ($modules as $name) {
    $files += _locale_ex_grab('modules/'. $name, isset($mod) ? $mod : $ext);
  }
  $files += _locale_ex_grab('includes', $ext) + _locale_ex_grab('misc', $ext);
  $files += array('install.php' => TRUE, 'update.php' => TRUE);
  foreach ($themes as $name) {
    $files += _locale_ex_grab('themes/'. $name, isset($mod) ? $mod : $ext);
  }
  return $files;
}
