<?php
// $Id: locale_ex.extract.inc,v 1.1.4.8 2008/04/21 16:52:27 z0rac Exp $

// Original: extractor.php,v 1.7.4.3 2006/02/01 20:06:07 goba Exp
/*
  Extracts translatable strings from t(), t(,array()), format_plural()
  and other function calls, plus adds some file specific strings. Only
  literal strings with no embedded variables can be extracted. Generates
  POT files, errors are printed on STDERR.

  Copyright (c) 2003, 2004 Alfa21 Outsourcing
  Created by Jacobo Tarrio <jtarrio [at] alfa21.com>
  with contributions from Gabor Hojtsy <goba [at] php.net>
  Licensed under the terms of the GNU General Public License
*/

function _locale_ex_extract_verify($name, $files, $installer = FALSE, $language = NULL) {
  list($msgs, $filelist) = _locale_ex_extract_parse($files, $installer, $language);
  if ($language) {
    $translated = 0;
    foreach ($msgs as $data) {
      if (!empty($data['msgstr'][0])) {
        ++$translated;
      }
    }
    drupal_set_message(format_plural($translated,
                                     '1 translated message', '@count translated messages') .', '.
                       format_plural(count($msgs) - $translated,
                                     '1 untranslated message', '@count untranslated messages'));
  }
  _locale_ex_extract_message();
}

function _locale_ex_extract_export($name, $files, $installer = FALSE, $language = NULL) {
  global $user;

  list($msgs, $filelist) = _locale_ex_extract_parse($files, $installer, $language);

  $header = array(
    'Project-Id-Version' => 'PROJECT VERSION',
    'POT-Creation-Date' => date("Y-m-d H:iO"),
    'PO-Revision-Date' => 'YYYY-mm-DD HH:MM+ZZZZ',
    'Last-Translator' => 'NAME <EMAIL@ADDRESS>',
    'Language-Team' => 'LANGUAGE <EMAIL@ADDRESS>',
    'MIME-Version' => '1.0',
    'Content-Type' => 'text/plain; charset=utf-8',
    'Content-Transfer-Encoding' => '8bit',
    'Plural-Forms' => 'nplurals=INTEGER; plural=EXPRESSION;'
  );
  $nplurals = 2;

  header('Content-Type: text/plain; charset=utf-8');
  if ($language) {
    header('Content-Disposition: attachment; filename='."$name.$language.po");

    $meta = db_fetch_object(db_query("SELECT * FROM {languages} WHERE language='%s'", $language));
    if ($meta->plurals) {
      $nplurals = $meta->plurals;
    }

    $header['PO-Revision-Date'] = $header['POT-Creation-Date'];
    $header['Last-Translator'] = "$user->name <$user->mail>";
    $header['Language-Team'] = "$meta->name <$user->mail>";
    if ($meta->formula && $meta->plurals) {
      $formula = strtr($meta->formula, array('$' => ''));
      $header['Plural-Forms'] = "nplurals=$meta->plurals; plural=$formula;";
    }
    print '# $' . 'Id' . '$' . "\n#\n";
    print "# $meta->name translation of Drupal ($name)\n";
    print '# Copyright '. date('Y') ." $user->name <$user->mail>\n";
  }
  else {
    header('Content-Disposition: attachment; filename='."$name.pot");
    print '# $' . 'Id' . '$' . "\n#\n";
    print "# LANGUAGE translation of Drupal ($name)\n";
    print "# Copyright YEAR NAME <EMAIL@ADDRESS>\n";
  }
  if ($n = count($filelist)) {
    print $n == 1 ?
      "# Generated from file: ". implode('', $filelist) :
      "# Generated from files:\n#  ". implode("\n#  ", $filelist);
  }
  else {
    print "# No version information was available in the source files.";
  }
  print "\n#\n#, fuzzy\n";
  print "msgid \"\"\n";
  print "msgstr \"\"\n";
  foreach ($header as $key => $value) {
    print "\"$key: $value\\n\"\n";
  }

  foreach ($msgs as $id => $data) {
    foreach ($data['files'] as $file => $lines) {
      print "\n#: ". $file .':'. implode(";", $lines);
    }
    print "\n";
    print _locale_ex_extract_print('msgid', $id);
    if (isset($data['plural'])) {
      print _locale_ex_extract_print('msgid_plural', $data['plural']);
      for ($i = 0; $i < $nplurals; ++$i) {
        print _locale_ex_extract_print(
          "msgstr[$i]", isset($data['msgstr'][$i]) ? $data['msgstr'][$i] : ''
        );
      }
    }
    else {
      print _locale_ex_extract_print(
        'msgstr', isset($data['msgstr'][0]) ? $data['msgstr'][0] : ''
      );
    }
  }
}

function _locale_ex_extract_print($id, $str, $width = 70) {
  $lines = array('');
  if ($str != '') {
    $func = '_locale_ex_extract_'. (function_exists('mb_strimwidth') ? 'mb_width': 'width');
    $str = addcslashes($str, "\0..\37\\\"");
    do {
      $sep = explode('\\n', $str, 2);
      if (isset($sep[1])) {
        $sep[0] .= '\\n';
        $str = $sep[1];
      }
      else {
        $str = '';
      }
      $lines = array_merge($lines, $func($sep[0], $width));
    } while ($str != '');
    if (count($lines) == 2 && count($func($lines[1], $width - strlen($id) - 1)) == 1) {
      array_shift($lines);
    }
  }
  return $id .' "'. implode("\"\n\"", $lines) ."\"\n";
}

function _locale_ex_extract_width($str, $width) {
  if (strlen($str) > $width) {
    $words = explode(' ', $str);
    $str = array_shift($words);
    foreach ($words as $word) {
      if (strlen($str .' '. $word) > $width) {
        $lines[] = $str .' ';
        $str = $word;
      }
      else {
        $str .= ' '. $word;
      }
    }
  }
  $lines[] = $str;
  return $lines;
}

function _locale_ex_extract_mb_width($str, $width) {
  static $cjk = '\x{3041}-\x{30ff}\x{31f0}-\x{31ff}\x{3400}-\x{4db5}\x{4e00}-\x{9fbb}\x{f900}-\x{fad9}';
  do {
    $cur = mb_strimwidth($str, 0, $width);
    if ($cur != $str) {
      if (preg_match('/^((?:.*[^\\\\])?(?:\\\\\\\\)*)\\\\$/', $cur, $match)) {
        $cur = $match[1];
      }
      if (preg_match('/[^ >'. $cjk .']+$/u', $cur, $match)) {
        $next = substr($str, strlen($cur));
        if ($match[0] != $cur) {
          if (preg_match('/^[^'. $cjk .']/u', $next)) {
            $cur = substr($cur, 0, -strlen($match[0]));
          }
        }
        else {
          if (preg_match('/^[^ <>'. $cjk .']+/u', $next, $match)) {
            $cur .= $match[0];
          }
          if ($str[strlen($cur)] == ' ') $cur .= ' ';
        }
      }
    }
    $lines[] = $cur;
    $str = substr($str, strlen($cur));
  } while ($str != '');
  return $lines;
}

function _locale_ex_extract_parse($files, $installer = FALSE, $language = NULL) {
  $versions = array();
  foreach ($files as $file) {
    $code = file_get_contents($file);
    // Get the exact version number from the file, so we can push that into the pot.
    // Prevent CVS from replacing this pattern with actual info.
    if (preg_match('!\\$I'. 'd: ([^\\$]+) \\$!', $code, $version_info)) {
      $versions[$file] = $version_info[1];
    }
    else {
      $versions[$file] = basename($file) .': n/a';
    }
    $fn = pathinfo($file);
    if (!isset($fn['filename'])) {
      $fn['filename'] = $fn['basename'];
      if (isset($fn['extension']) && $fn['extension'] != '') {
        $fn['filename'] = basename($fn['filename'], '.'. $fn['extension']);
      }
    }
    if (in_array($fn['extension'], array('info', 'js'))) {
      if (!$installer) {
        $function = '_locale_ex_extract_'. $fn['extension'] .'_file';
        $function($code, $file);
      }
      continue;
    }
    // Extract raw tokens
    $raw_tokens = token_get_all($code);
    unset($code);
    // Remove whitespace and HTML
    $tokens = array();
    $indexes = array();
    $index = 0;
    $lineno = 1;
    $end = count($raw_tokens);
    for ($i = 0; $i < $end; ++$i) {
      $tok = $raw_tokens[$i];
      unset($raw_tokens[$i]);
      if (is_array($tok)) {
        if ($tok[0] == T_WHITESPACE || $tok[0] == T_INLINE_HTML) {
          $lineno += count(split("\n", $tok[1])) - 1;
          continue;
        }
        $tok[] = $lineno;
        // Fill array for finding token offsets quickly.
        if ($tok[0] == T_STRING || ($tok[0] == T_VARIABLE && $tok[1] == '$t')) {
          if ($raw_tokens[$i + 1] == '(') {
            if (!isset($indexes[$tok[1]])) {
              $indexes[$tok[1]] = array();
            }
            $indexes[$tok[1]][] = $index;
          }
        }
        $lineno += count(split("\n", $tok[1])) - 1;
      }
      else {
        $lineno += count(split("\n", $tok)) - 1;
      }
      $tokens[] = $tok;
      $index++;
    }
    unset($raw_tokens);

    _locale_ex_extract_t_calls($tokens, $indexes, $file, $installer ? 'st' : 't');
    _locale_ex_extract_t_calls($tokens, $indexes, $file, '_locale_import_message');
    _locale_ex_extract_t_calls($tokens, $indexes, $file, '$t');
    if (!$installer) {
      _locale_ex_extract_watchdog_calls($tokens, $indexes, $file);
      _locale_ex_extract_format_plural_calls($tokens, $indexes, $file);
      switch ($fn['extension']) {
        case 'module':
          _locale_ex_extract_hooks($tokens, $indexes, $file, $fn['filename'] .'_perm');
          _locale_ex_extract_menu_hook($tokens, $indexes, $file, $fn['filename'] .'_menu');
          _locale_ex_extract_hooks($tokens, $indexes, $file, $fn['filename'] .'_node_types');
        case 'theme':
          _locale_ex_extract_store($file, 0, $fn['filename']);
          break;
      }
      if ($file == 'includes/locale.inc') {
        _locale_ex_extract_language_names($tokens, $indexes, $file);
      }
      elseif ($fn['basename'] == 'locale.module') {
        _locale_ex_extract_date_strings($file);
      }
      elseif ($file == 'includes/common.inc') {
        _locale_ex_extract_format_interval_strings($file);
      }
      elseif ($fn['basename'] == 'system.module') {
        _locale_ex_extract_region_strings($file);
      }
      elseif ($fn['basename'] == 'user.module') {
        foreach (array('anonymous user', 'authenticated user') as $name) {
          _locale_ex_extract_store($file, 0, $name);
        }
      }
    }
  }
  list($msgs, $files) = _locale_ex_extract_store();
  if ($language) {
    $plid = array();
    $result = db_query("SELECT s.lid, s.source, t.translation, t.plid, t.plural".
                       " FROM {locales_source} s".
                       " INNER JOIN {locales_target} t ON s.lid = t.lid".
                       " WHERE t.language = '%s' AND s.textgroup = 'default'".
                       " ORDER BY t.plid, t.plural", $language);
    while ($tr = db_fetch_object($result)) {
      if (isset($plid[$tr->plid])) {
        $msgs[$plid[$tr->plid]]['msgstr'][$tr->plural] = $tr->translation;
        $plid[$tr->lid] = $tr->source;
      }
      elseif ($tr->plid == 0 && isset($msgs[$tr->source])) {
        $msgs[$tr->source]['msgstr'] = array($tr->translation);
        if (isset($msgs[$tr->source]['plural'])) {
          $plid[$tr->lid] = $tr->source;
        }
      }
    }
    unset($plid, $result);
  }
  foreach ($files as $file) {
    if (isset($versions[$file])) {
      $filelist[] = $versions[$file];
    }
  }
  return array($msgs, $filelist);
}

function _locale_ex_extract_store($file = NULL, $line = 0, $msg = '', $plural = '') {
  static $store = array();
  static $files = array();

  if (!isset($file)) {
    $result = array($store, array_keys($files));
    $store = $files = array();
    return $result;
  }
  $msg = _locale_ex_extract_unquote($msg);
  if ($msg != '') {
    $plural = _locale_ex_extract_unquote($plural);
    if (!isset($store[$msg])) {
      $store[$msg] = array('msgstr' => array(), 'files' => array());
    }
    elseif ((isset($store[$msg]['plural']) ? $store[$msg]['plural'] : '') != $plural) {
      _locale_ex_extract_message(t('Duplicate plural messages in %file:%line<br />* %msg, %plural',
                                   array('%file' => $file, '%line' => $line,
                                         '%msg' => $msg, '%plural' => $plural)), 'error');
    }
    if ($plural != '') {
      $store[$msg]['plural'] = $plural;
    }
    $store[$msg]['files'][$file][] = $line;
    $files[$file] = TRUE;
  }
  else {
    _locale_ex_extract_message(t('Empty message in %file:%line',
                                 array('%file' => $file, '%line' => $line)), 'error');
  }
}

function _locale_ex_extract_unquote($msg) {
  $result = '';
  foreach ((array)$msg as $str) {
    $quo = substr($str, 0, 1);
    if ($quo == '"') {
      $str = stripcslashes(substr($str, 1, -1));
    }
    elseif ($quo == "'") {
      $str = strtr(substr($str, 1, -1), array("\\'" => "'", "\\\\" => "\\"));
    }
    $result .= $str;
  }
  return $result;
}

function _locale_ex_extract_message($message = NULL, $type = 'status') {
  static $m = array();
  static $t = array();
  if ($message) {
    $m[] = $message;
    $t[] = $type;
  }
  else {
    array_map('drupal_set_message', $m, $t);
    $m = array();
    $t = array();
  }
}

function _locale_ex_extract_find($name, &$tokens, $ti) {
  $type = $name[0] == '$' ? T_VARIABLE : T_STRING;
  while (isset($tokens[$ti + 4])) {
    if (is_array($tokens[$ti]) &&
        $tokens[$ti][0] == $type && $tokens[$ti][1] == $name && $tokens[$ti + 1] == '(') {
      return $ti;
    }
    $ti++;
  }
}

function _locale_ex_extract_literal(&$tokens, $ti) {
  $li = array();
  while (is_array($tokens[$ti]) && $tokens[$ti][0] == T_CONSTANT_ENCAPSED_STRING) {
    $li[] = $tokens[$ti++][1];
    if ($tokens[$ti] !== '.') break;
    $ti++;
  }
  return array($li, $ti);
}

function _locale_ex_extract_error(&$tokens, $ti, $file) {
  $output = '';
  $line = $tokens[$ti][2];
  $depth = 0;
  while (isset($tokens[$ti])) {
    if (is_array($tokens[$ti])) {
      $output .= $tokens[$ti][1];
    }
    else {
      $output .= $tokens[$ti];
      if ($tokens[$ti] == '(') {
        $depth++;
      }
      elseif ($tokens[$ti] == ')') {
        if (--$depth < 1) break;
      }
    }
    $ti++;
  }
  _locale_ex_extract_message(t('Invalid marker content in %file:%line<br />* %marker',
                               array('%file' => $file, '%line' => $line,
                                     '%marker' => $output)), 'error');
}

/*
  Detect all occurances of one of these sequences:
    T_STRING("t") + "(" + T_CONSTANT_ENCAPSED_STRING + ")"
    T_STRING("t") + "(" + T_CONSTANT_ENCAPSED_STRING + ","
*/
function _locale_ex_extract_t_calls(&$tokens, &$indexes, $file, $funcname = 't') {
  if (isset($indexes[$funcname])) {
    foreach ($indexes[$funcname] as $ti) {
      list($li, $tn) = _locale_ex_extract_literal($tokens, $ti + 2);
      if ($tokens[$tn] == ')' || $tokens[$tn] == ',') {
        _locale_ex_extract_store($file, $tokens[$ti][2], $li);
        continue;
      }
      // t() found, but inside is something which is not a string literal
      _locale_ex_extract_error($tokens, $ti, $file);
    }
  }
}

function _locale_ex_extract_watchdog_calls(&$tokens, &$indexes, $file) {
  if (isset($indexes['watchdog'])) {
    foreach ($indexes['watchdog'] as $ti) {
      list($type, $tn) = _locale_ex_extract_literal($tokens, $ti + 2);
      if ($tokens[$tn] == ',') {
        list($msg, $tn) = _locale_ex_extract_literal($tokens, $tn + 1);
        if ($tokens[$tn] == ')' || $tokens[$tn] == ',') {
          _locale_ex_extract_store($file, $tokens[$ti][2], $type);
          _locale_ex_extract_store($file, $tokens[$ti][2], $msg);
          continue;
        }
      }
      // watchdog() found, but the parameters are not correct
      _locale_ex_extract_error($tokens, $ti, $file);
    }
  }
}

/*
  Detect all occurances this sequence:
    T_STRING("format_plural") + "(" + ..anything (might be more tokens).. +
    "," + T_CONSTANT_ENCAPSED_STRING +
    "," + T_CONSTANT_ENCAPSED_STRING + ")"
*/
function _locale_ex_extract_format_plural_calls(&$tokens, &$indexes, $file) {
  if (isset($indexes['format_plural'])) {
    foreach ($indexes['format_plural'] as $ti) {
      // Eat up everything that is used as the first parameter
      $tn = $ti + 2;
      $depth = 0;
      while (isset($tokens[$tn]) && ($depth || $tokens[$tn] != ',')) {
        if ($tokens[$tn] == '(') {
          $depth++;
        }
        elseif ($tokens[$tn] == ')') {
          if (--$depth < 0) break;
        }
        $tn++;
      }
      if ($tokens[$tn] == ',') {
        list($singular, $tn) = _locale_ex_extract_literal($tokens, $tn + 1);
        if ($singular && $tokens[$tn] == ',') {
          list($plural, $tn) = _locale_ex_extract_literal($tokens, $tn + 1);
          if ($plural && ($tokens[$tn] == ')' || $tokens[$tn] == ',')) {
            _locale_ex_extract_store($file, $tokens[$ti][2], $singular, $plural);
            continue;
          }
        }
      }
      // format_plural() found, but the parameters are not correct
      _locale_ex_extract_error($tokens, $ti, $file);
    }
  }
}

function _locale_ex_extract_hooks(&$tokens, &$indexes, $file, $hook) {
  if (isset($indexes[$hook])) {
    foreach ($indexes[$hook] as $ti) {
      if (is_array($tokens[$ti - 1]) && $tokens[$ti - 1][0] == T_FUNCTION) {
        if ($hook == 'node_perm') {
          $line = $tokens[$ti][2];
          $perms = array(
            'administer content types',
            'administer nodes',
            'access content',
            'view revisions',
            'revert revisions'
          );
          foreach ($perms as $item) {
            _locale_ex_extract_store($file, $line, $item);
          }
        }
        else {
          $nest = 0;
          while (isset($tokens[$ti])) {
            if (is_array($tokens[$ti])) {
              if ($nest && $tokens[$ti][0] == T_CONSTANT_ENCAPSED_STRING) {
                list($item, $tn) = _locale_ex_extract_literal($tokens, $ti);
                _locale_ex_extract_store($file, $tokens[$ti][2], $item);
                $ti = $tn - 1;
              }
            }
            elseif ($tokens[$ti] === '{') {
              $nest++;
            }
            elseif ($tokens[$ti] === '}') {
              $nest--;
              if (!$nest) {
                break;
              }
            }
            $ti++;
          }
        }
        break;
      }
    }
  }
}

function _locale_ex_extract_menu_hook(&$tokens, &$indexes, $file, $hook) {
  if (isset($indexes[$hook])) {
    foreach ($indexes[$hook] as $ti) {
      if (is_array($tokens[$ti - 1]) && $tokens[$ti - 1][0] == T_FUNCTION) {
        $nest = 0;
        while (isset($tokens[$ti])) {
          if (is_array($tokens[$ti])) {
            if ($nest && $tokens[$ti][0] == T_CONSTANT_ENCAPSED_STRING) {
              list($item, $ti) = _locale_ex_extract_literal($tokens, $ti);
              if (in_array(_locale_ex_extract_unquote($item), array('title', 'description'))) {
                if (is_array($tokens[$ti]) && $tokens[$ti][0] == T_DOUBLE_ARROW) {
                  $ti++;
                }
                else if ($tokens[$ti] === ']' && $tokens[$ti + 1] === '=') {
                  $ti += 2;
                }
                else {
                  continue;
                }
                if (is_array($tokens[$ti]) && $tokens[$ti][0] == T_CONSTANT_ENCAPSED_STRING) {
                  list($item, $tn) = _locale_ex_extract_literal($tokens, $ti);
                  _locale_ex_extract_store($file, $tokens[$ti][2], $item);
                  $ti = $tn - 1;
                }
              }
            }
          }
          elseif ($tokens[$ti] === '{') {
            $nest++;
          }
          elseif ($tokens[$ti] === '}') {
            $nest--;
            if (!$nest) {
              break;
            }
          }
          $ti++;
        }
      }
      break;
    }
  }
}

function _locale_ex_extract_language_names(&$tokens, &$indexes, $file) {
  if (isset($indexes['_locale_get_predefined_list'])) {
    foreach ($indexes['_locale_get_predefined_list'] as $ti) {
      if (is_array($tokens[$ti - 1]) && $tokens[$ti - 1][0] == T_FUNCTION) {
        while (isset($tokens[$ti]) && $tokens[$ti] !== '}') {
          if (is_array($tokens[$ti]) && $tokens[$ti][0] == T_DOUBLE_ARROW) {
            list($item, $tn) = _locale_ex_extract_literal($tokens, $ti + 3);
            _locale_ex_extract_store($file, $tokens[$ti + 3][2], $item);
            $ti = $tn - 1;
          }
          $ti++;
        }
        break;
      }
    }
  }
}

// Add date strings if locale.module is parsed
function _locale_ex_extract_date_strings($file) {
  for ($i = 1; $i <= 12; $i++) {
    $stamp = mktime(0, 0, 0, $i, 1, 1971);
    _locale_ex_extract_store($file, 0, '!long-month-name '. date("F", $stamp));
    _locale_ex_extract_store($file, 0, date("M", $stamp));
  }

  for ($i = 0; $i <= 7; $i++) {
    $stamp = $i * 86400;
    _locale_ex_extract_store($file, 0, date("D", $stamp));
    _locale_ex_extract_store($file, 0, date("l", $stamp));
  }

  foreach (array('am', 'pm', 'AM', 'PM') as $i) {
    _locale_ex_extract_store($file, 0, $i);
  }
}

// Add format_interval special strings if common.inc is parsed
function _locale_ex_extract_format_interval_strings($file) {
  $components = array(
    '1 year' => '@count years',
    '1 week' => '@count weeks',
    '1 day'  => '@count days',
    '1 hour' => '@count hours',
    '1 min'  => '@count min',
    '1 sec'  => '@count sec'
  );
  foreach ($components as $singular => $plural) {
    _locale_ex_extract_store($file, 0, $singular, $plural);
  }
}

function _locale_ex_extract_region_strings($file) {
  foreach(array('Left sidebar', 'Right sidebar', 'Content', 'Header', 'Footer') as $name) {
    _locale_ex_extract_store($file, 0, $name);
  }
}

function _locale_ex_extract_info_file($code, $file) {
  if (file_exists($file)) {
    $info = drupal_parse_info_file($file);
    foreach (array('name', 'description', 'package') as $key) {
      if (isset($info[$key])) {
        _locale_ex_extract_store($file, 0, $info[$key]);
      }
    }
    if (isset($info['regions']) && is_array($info['regions'])) {
      foreach($info['regions'] as $name) {
        _locale_ex_extract_store($file, 0, $name);
      }
    }
  }
}

function _locale_ex_extract_js_file($code, $file) {
  $code = preg_replace_callback('/[^\w]Drupal\s*\.\s*t\s*\(\s*
    ((?:(?:("|\')(?:\\\\.|[^\\\\]+)*\2)(?:\s*\+\s*)?)+)
    \s*[,\)]/SUsx', '_locale_ex_extract_js_file_cb', $code);
  $code = preg_replace_callback('/[^\w]Drupal\s*\.\s*formatPlural\s*\(.+,\s*
    ((?:(?:("|\')(?:\\\\.|[^\\\\]+)*\2)(?:\s*\+\s*)?)+)
    \s*,\s*
    ((?:(?:("|\')(?:\\\\.|[^\\\\]+)*\4)(?:\s*\+\s*)?)+)
    \s*[,\)]/SUsx', '_locale_ex_extract_js_file_cb', $code);
  foreach(_locale_ex_extract_js_file_cb() as $msg) {
    _locale_ex_extract_store($file, 0, $msg[0], $msg[1]);
  }
  preg_match_all('/[^\w]Drupal\s*\.\s*(t|formatPlural)\s*\([^)]+\)/s', $code, $match);
  foreach ($match[0] as $match) {
    _locale_ex_extract_message(t('Invalid marker content in %file<br />* %marker',
                                 array('%file' => $file, '%marker' => $match)), 'error');
  }
}

function _locale_ex_extract_js_file_cb($match = NULL) {
  static $store = array();
  if (!isset($match)) {
    $r = $store;
    $store = array();
    return $r;
  }
  static $regex = '/(("|\')(?:\\\\.|[^\\\\]+)*\2)/Us';
  $plural = array();
  if (isset($match[3])) {
    preg_match_all($regex, $match[3], $s);
    $plural = $s[1];
  }
  preg_match_all($regex, $match[1], $s);
  $store[] = array($s[1], $plural);
}
