<?php
// $Id: update_locale.admin.inc,v 1.4.2.1 2008/02/12 15:14:11 z0rac Exp $

function _update_locale_admin_menu() {
  if ($args = func_get_args()) {
    return call_user_func_array('_update_locale_admin_language', $args);
  }
  return drupal_get_form('_update_locale_admin_overview');
}

function _update_locale_admin_overview() {
  include_once './includes/install.inc';
  $langs = locale_language_list();
  unset($langs['en']);

  $items = array();
  foreach ($langs as $code => $name) {
    $items[$code]['title'] = l($name, 'admin/build/translate/update/'. $code .'/info');
    $items[$code]['value'] = t('Up to date');
    $result = db_query("SELECT count(*) FROM {update_locale_string} WHERE language='%s'", $code);
    if ($n = db_result($result)) {
      $items[$code]['value'] = l(
        format_plural($n, '1 updated string', '@count updated strings'),
        'admin/build/translate/update/'. $code
      );
      $items[$code]['severity'] = REQUIREMENT_WARNING;
    }
  }
  $form['status'] = array(
    '#type' => 'fieldset',
    '#title' => t('Status'),
    '#collapsible' => TRUE,
    'items' => array('#value' => theme('status_report', $items)),
    'updatenow' => array('#type' => 'submit', '#value' => t('Update now'))
  );
  $form['settings'] = array(
    '#type' => 'fieldset',
    '#title' => t('Settings'),
    '#collapsible' => TRUE
  );
  $form['settings']['update_locale_moderation'] = array(
    '#type' => 'radios',
    '#title' => t('Moderation'),
    '#default_value' => variable_get('update_locale_moderation', 1),
    '#options' => array(0 => t('Disabled'), 1 => t('Enabled')),
    '#description' => t('When enabled, the updated strings will be applied after approval.')
  );
  $form['settings']['update_locale_moderation'] = array(
    '#type' => 'radios',
    '#title' => t('Moderation'),
    '#default_value' => variable_get('update_locale_moderation', 1),
    '#options' => array(0 => t('Disabled'), 1 => t('Enabled')),
    '#description' => t('When enabled, the updated strings will be applied after approval.')
  );
  $form['settings']['update_locale_cvs'] =  array(
    '#type' => 'textfield',
    '#title' => t('CVS repository for translations'),
    '#default_value' => variable_get('update_locale_cvs', ''),
    '#description' => t('Choose the repository of translation files.')
  );
  $period = drupal_map_assoc(array(0, 3600, 10800, 21600, 32400, 43200, 86400, 172800, 259200, 604800), 'format_interval');
  $period[0] = t('none');
  $form['settings']['update_locale_interval'] = array(
    '#type' => 'select',
    '#title' => t('Update interval'),
    '#default_value' => variable_get('update_locale_interval', 0),
    '#options' => $period,
    '#description' => t('The interval indicating how often you want to update translated strings. Requires crontab.')
  );

  $form = system_settings_form($form);
  $form['#submit'] = array('_update_locale_admin_updatenow');
  return $form;
}

function _update_locale_admin_updatenow($form_id, &$form_state) {
  if ($form_state['values']['op'] == $form_state['values']['updatenow']) {
    _update_locale_translations();
    return;
  }
  return system_settings_form_submit($form_id, $form_state);
}

function _update_locale_admin_language($lang, $kind = NULL) {
  $langs = locale_language_list();
  unset($langs['en']);
  if (!isset($langs[$lang])) {
    return drupal_not_found();
  }
  if ($kind) {
    if ($kind == 'info') {
      $output = '<h3>'. t('@name - Translation information', array('@name' => $langs[$lang])) .'</h3>';
      $types = array('module' => t('Modules'), 'theme' => t('Themes'));
      foreach ($types as $type => $title) {
        $header = array(
          array('data' => t('Name'), 'field' => 'name', 'sort' => 'asc'),
          array('data' => t('Translator'), 'field' => 'translator'),
          array('data' => t('Team'), 'field' => 'team'),
          array('data' => t('Date'), 'field' => 'ftime')
        );
        $rows = array();
        $result = db_query("SELECT * FROM {update_locale_file} WHERE type='%s' AND language='%s' ". tablesort_sql($header), $type, $lang);
        while ($tr = db_fetch_object($result)) {
          $rows[] = array(
            array('data' => check_plain($tr->name)),
            array('data' => check_plain($tr->translator)),
            array('data' => check_plain($tr->team)),
            array('data' => format_date($tr->ftime, 'small'))
          );
        }
        if ($rows) {
          $fieldset = array(
            '#title' => $title,
            '#collapsible' => TRUE,
            '#value' => theme('table', $header, $rows)
          );
          $output .= theme('fieldset', $fieldset);
        }
      }
      return $output;
    }
    return drupal_not_found();
  }
  return drupal_get_form('_update_locale_admin_string', $lang, $langs[$lang]);
}

function _update_locale_admin_string(&$form_state, $lang, $name) {
  $operations = array(
    '_update_locale_update_strings' => t('Update the selected strings'),
    '_update_locale_ignore_strings' => t('Ignore the selected strings')
  );

  $form = array();
  $form['lang'] = array('#type' => 'value', '#value' => $lang);
  $form['title'] = array(
    '#prefix' => '<h3>', '#value' => check_plain($name), '#suffix' => '</h3>'
  );
  $form['update'] = array(
    '#type' => 'fieldset',
    '#title' => t('Update options'),
    'operations' => array('#type' => 'value', '#value' => $operations),
    'operation' => array(
      '#prefix' => '<div class="container-inline">',
      '#type' => 'select',
      '#options' => $operations
    ),
    'op' => array(
      '#type' => 'submit',
      '#value' => t('Update'),
      '#suffix' => '</div>'
    )
  );

  $form['strings'] = array('#theme' => 'update_locale_admin_string_table');
  $form['strings']['header'] = array(
    '#type' => 'value',
    '#value' => array(
      theme('table_select_header_cell'),
      array('data' => t('New string'), 'field' => 'u.translation'),
      array('data' => t('Old string'), 'field' => 't.translation'),
      array('data' => t('Original string'), 'field' => 's.source')
    )
  );
  $form['strings']['status'] = array('#tree' => TRUE);

  $sql = "SELECT u.lid, u.translation AS new, t.translation AS old, s.source";
  $sql .= " FROM {update_locale_string} u";
  $sql .= " LEFT JOIN {locales_target} t USING (lid, language)";
  $sql .= " LEFT JOIN {locales_source} s USING (lid)";
  $sql .= " WHERE u.language='". db_escape_string($lang) ."' ";
  $result = pager_query($sql . tablesort_sql($form['strings']['header']['#value']), 20);
  while ($st = db_fetch_object($result)) {
    $form['strings']['status'][$st->lid] = array('#type' => 'checkbox');
    $form['strings'][$st->lid][] = array('#value' => check_plain($st->new));
    $form['strings'][$st->lid][] = array('#value' => check_plain($st->old));
    $form['strings'][$st->lid][] = array(
      '#value' => '<small>'. check_plain($st->source) .'</small>'
    );
  }
  $form['pager'] = array('#value' => theme('pager', NULL, 20, 0));

  return $form;
}

function _update_locale_admin_string_validate($form_id, $form_state) {
  $status = array();
  if (isset($form_state['values']['status'])) {
    $status = array_diff((array)$form_state['values']['status'], array(0));
  }
  if (count($status) == 0) {
    form_set_error('', t('Please select one or more strings to perform the update on.'));
    drupal_goto($_GET['q']);
  }
}

function _update_locale_admin_string_submit($form_id, $form_state) {
  if (isset($form_state['values']['operations'][$form_state['values']['operation']])) {
    $lang = $form_state['values']['lang'];
    $function = $form_state['values']['operation'];
    foreach ($form_state['values']['status'] as $lid => $value) {
      if ($value && $function($lid, $lang)) {
        $refresh = TRUE;
      }
    }
    if ($refresh) {
      include_once './includes/locale.inc';
      _locale_invalidate_js($lang);
      cache_clear_all('locale:'. $lang, 'cache');
      menu_rebuild();
    }
    drupal_set_message(t('The update has been performed.'));
  }
}

function theme_update_locale_admin_string_table($form) {
  $rows = array();
  foreach (element_children($form['status']) as $key) {
    $row = array(drupal_render($form['status'][$key]));
    foreach (element_children($form[$key]) as $column) {
      $row[] = drupal_render($form[$key][$column]);
    }
    $rows[] = $row;
  }
  $header = $form['header']['#value'];
  if (count($rows) == 0) {
    $rows[][] = array(
      'data' => t('No strings available.'),
      'colspan' => count($header)
    );
  }
  return theme('table', $header, $rows);
}

function _update_locale_update_strings($lid, $lang) {
  $u = db_result(db_query("SELECT translation FROM {update_locale_string} WHERE lid=%d AND language='%s'", $lid, $lang));
  if ($u != '') {
    db_query("UPDATE {locales_target} SET translation='%s' WHERE lid=%d AND language='%s'", $u, $lid, $lang);
  }
  else {
    db_query("DELETE FROM {locales_target} WHERE lid=%d AND language='%s'", $lid, $lang);
  }
  db_query("DELETE FROM {update_locale_string} WHERE lid=%d AND language='%s'", $lid, $lang);
  return TRUE;
}

function _update_locale_ignore_strings($lid, $lang) {
  db_query("DELETE FROM {update_locale_string} WHERE lid=%d AND language='%s'", $lid, $lang);
}
