<?php
// $Id: locale_ex.modules.inc,v 1.1.2.3 2007/11/04 09:22:24 z0rac Exp $

/*
 * Page handler for the localization of modules screen
 */
function locale_ex_modules() {
  $options = array();
  foreach (array('profiles', 'themes', 'modules') as $type) {
    $projects = call_user_func('_locale_ex_collect_'. $type);
    $form[$type] = array('#type' => 'value', '#value' => $projects);
    foreach ($projects as $key => $files) {
      $name = count($files) > 1 ? basename($key) : key($files);
      $options[$key] = isset($files[$name]['name']) ? $files[$name]['name'] : $name;
    }
  }
  $form['project'] = array(
    '#type' => 'radios',
    '#default_value' => key($options),
    '#options' => $options
  );
  if ($languages = _locale_ex_languages()) {
    $form['langcode'] = array(
      '#type' => 'select',
      '#title' => t('Language name'),
      '#default_value' => key($languages),
      '#options' => array('' => t('<none>')) + $languages,
      '#description' => t('Select the language you would like to export in gettext Portable Object (.po) format. If you select <em>&lt;none&gt;</em>, a gettext Portable Object Template (.pot) file will be generated.')
    );
  }
  $form['buttons']['submit'] = array('#type' => 'submit', '#value' => t('Extract'));
  $form['buttons']['validate'] = array('#type' => 'submit', '#value' => t('Validate'));
  return $form;
}

function _locale_ex_collect_profiles() {
  $profiles = array();
  $profiles['/']['/'] = array(
    'name' => 'Drupal',
    'description' => t('Drupal core system.')
  );
  $files = file_scan_directory('profiles', '.+\.profile$', array('.', '..', 'CVS'), 0, TRUE, 'name', 1);
  ksort($files);
  foreach ($files as $file) {
    $key = dirname($file->filename);
    $profiles[$key][$file->name] = array(
      'description' => t('Installation profile %name.', array('%name' => $file->name))
    );
  }
  return $profiles;
}

function _locale_ex_collect_themes() {
  $themes = array();
  $files = drupal_system_listing('\.theme$', 'themes');
  $engines = drupal_system_listing('\.engine$', 'themes/engines');
  foreach ($engines as $file) {
    drupal_get_filename('theme_engine', $file->name, $file->filename);
    drupal_load('theme_engine', $file->name);
    foreach (call_user_func($file->name .'_templates') as $file) {
      $file->name = basename(dirname($file->filename));
      if (!isset($files[$file->name])) {
        $files[$file->name] = $file;
      }
    }
  }
  ksort($files);
  foreach ($files as $name => $file) {
    if (preg_match('"^(?:[^/]*/)*?themes/[^/]+"', $file->filename, $path)) {
      $themes[$path[0]][$name] = array(
        'description' => theme('placeholder', dirname($file->filename))
      );
      foreach (file_scan_directory(dirname($file->filename), 'style.css$') as $file) {
        $file->name = basename(dirname($file->filename));
        if (!isset($themes[$path[0]][$file->name])) {
          $themes[$path[0]][$file->name] = array(
            'description' => theme('placeholder', dirname($file->filename))
          );
        }
      }
    }
  }
  ksort($engines);
  foreach ($engines as $name => $file) {
    if (preg_match('"^(?:[^/]*/)*?themes/engines/[^/]+"', $file->filename, $path)) {
      $themes[$path[0]][$name] = array(
        'description' => theme('placeholder', dirname($file->filename))
      );
    }
  }
  return $themes;
}

function _locale_ex_collect_modules() {
  $modules = array();
  $files = drupal_system_listing('\.module$', 'modules', 'name', 0);
  ksort($files);
  foreach ($files as $file) {
    if ($info = _module_parse_info_file(dirname($file->filename) .'/'. $file->name .'.info')) {
      if (preg_match('"^(?:[^/]*/)*?modules/[^/]+"', $file->filename, $path)) {
        $modules[$path[0]][$file->name] = $info;
      }
    }
  }
  $form['modules'] = array('#type' => 'value', '#value' => $modules);
  return $modules;
}

/*
 * Process the localization of modules submissions.
 */
function locale_ex_modules_submit($id, &$values) {
  if ($project = $values['project']) {
    $installer = FALSE;
    if (isset($values['profiles'][$project])) {
      if ($project == '/') {
        $files = _locale_ex_core_files();
        $name = 'drupal';
      }
      elseif (is_dir($project)) {
        $files = _locale_ex_grab($project, 'profile|module|theme|install');
        $files = array_merge($files, _locale_ex_core_files(FALSE));
        $installer = TRUE;
        $name = basename($project);
      }
    }
    elseif (isset($values['themes'][$project])) {
      if (is_dir($project)) {
        $files = _locale_ex_grab($project, 'theme|engine');
        $name = basename($project);
      }
    }
    else {
      if (is_dir($project)) {
        $files = _locale_ex_grab($project, 'module|install|info');
        $name = basename($project);
      }
      elseif (file_exists($project)) {
        $dir = dirname($project);
        $files = array($project);
        $name = basename($project, '.module');
        foreach (array('install', 'info') as $suffix) {
          $file = "$dir/$project.$suffix";
          if (file_exists($file)) {
            $files[] = $file;
          }
        }
      }
    }
    if ($files) {
      include_once 'locale_ex.extract.inc';
      if ($values['op'] == $values['submit']) {
        _locale_ex_extract_export($name, $files, $installer, $values['langcode']);
        exit;
      }
      _locale_ex_extract_verify($name, $files, $installer, $values['langcode']);
    }
    return FALSE;
  }
}

function theme_locale_ex_modules($form) {
  foreach ($form['modules']['#value'] as $key => $modules) {
    $name = basename($key);
    $info = isset($modules[$name]) ? $modules[$name] : current($modules);
    $packages[!empty($info['package']) ? $info['package'] : 'Other'][$key] = $modules;
  }
  ksort($packages);
  $output .= _locale_ex_package_table($form, $form['profiles']['#value']);
  $output .= _locale_ex_package_table($form, $form['themes']['#value'], t('Themes of this project'), t('Themes'));
  foreach ($packages as $name => $modules) {
    $output .= _locale_ex_package_table($form, $modules, t('Modules of this project'), $name);
  }
  $output .= drupal_render($form);
  return $output;
}

function _locale_ex_package_table(&$form, $package, $title = '', $name = NULL) {
  $collapsed = isset($name);
  $value = $form['project']['#value'] != '/' ? $form['project']['#value'] : '';
  $rows = array();
  foreach ($package as $key => $project) {
    $desc = '';
    if (count($project) > 1) {
      foreach ($project as $info) {
        $desc .= '<dt>'. $info['name'] .'</dt>';
        $desc .= '<dd><div class="description">'. t($info['description']) .'</div></dd>';
      }
      $fieldset = array(
        '#title' => $title,
        '#collapsible' => TRUE,
        '#collapsed' => $key != $value,
        '#value' => '<dl>'. $desc .'</dl>'
      );
      $desc = theme('fieldset', $fieldset);
      $info = basename($key);
    }
    else {
      $info = key($project);
    }
    if (isset($project[$info]) && isset($project[$info]['description'])) {
      $desc = '<div class="description">'. t($project[$info]['description']) .'</div>'. $desc;
    }
    if ($collapsed) {
      if ($value) {
        $collapsed = ($key != $value);
      }
      elseif (isset($form['modules']['#value'][$key])) {
        if (!isset($project[$info])) {
          $info = key($project);
        }
        $collapsed = ($project[$info]['project'] == 'drupal');
      }
    }
    $rows[] = array(drupal_render($form['project'][$key]), $desc);
  }
  $output = theme('table', array(t('Name'), t('Description')), $rows, array('class' => 'package'));
  if (isset($name)) {
    $fieldset = array(
      '#title' => t($name),
      '#collapsible' => TRUE,
      '#collapsed' => $collapsed,
      '#value' => $output
    );
    $output = theme('fieldset', $fieldset);
  }
  return $output;
}

function _locale_ex_grab($dir, $ext = '') {
  $files = array();
  if (is_dir($dir)) {
    $files = array_keys(file_scan_directory($dir, '.+\.(php|inc'. ($ext ? "|$ext" : '') .')$'));
  }
  return $files;
}

/*
 * Make list of Drupal's core files.
 */
function _locale_ex_core_files($all = TRUE) {
  $modules = array(
    'aggregator', 'block', 'blog', 'blogapi', 'book', 'color', 'comment', 'contact',
    'drupal', 'filter', 'forum', 'help', 'legacy', 'locale', 'menu', 'node',
    'path', 'ping', 'poll', 'profile', 'search', 'statistics', 'system',
    'taxonomy', 'throttle', 'tracker', 'upload', 'user', 'watchdog',
  );
  $files = array();
  foreach ($modules as $name) {
    $files = array_merge($files, _locale_ex_grab("modules/$name", 'module|install|info'));
  }
  $files = array_merge($files, _locale_ex_grab('includes'), array('cron.php', 'install.php'));
  if ($all) {
    $themes = array('bluemarine', 'chameleon', 'garland', 'pushbutton', 'engines/phptemplate');
    foreach ($themes as $name) {
      $files = array_merge($files, _locale_ex_grab("themes/$name", 'theme|engine'));
    }
  }
  return $files;
}
