<?php
// $Id: pdatheme.theme.inc,v 1.1 2007/10/01 14:48:22 z0rac Exp $

function pdatheme_image_url($url) {
  global $base_url;
  foreach (array($base_url .'/', base_path()) as $base) {
    if (strpos($url, $base) === 0) {
      $path = substr($url, strlen($base));
      return $base . (strncmp($path, 'pdatheme/', 9) == 0 ? $path : 'pdatheme/'. $path);
    }
  }
  return $url;
}

function pdatheme_content_filter($output) {
  return preg_replace_callback('/(<img\s.*\bsrc\s*=\s*("|\'))(.+)\2/Us', '_pdatheme_repimg', $output);
}

function _pdatheme_repimg($match) {
  return $match[1] . pdatheme_image_url($match[3]) . $match[2];
}

function pdatheme_cache($id, $data = NULL) {
  global $user, $base_root;
  if (!$user->uid && $_SERVER['REQUEST_METHOD'] == 'GET') {
    if (isset($data)) {
      if (count(drupal_get_messages(NULL, FALSE)) == 0) {
        cache_set($id .':'. $base_root . request_uri(), 'cache_page', $data, CACHE_TEMPORARY, drupal_get_headers());
        _pdatheme_cache_header(time());
      }
    }
    elseif (count(drupal_set_message()) == 0) {
      if ($cache = cache_get($id .':'. $base_root . request_uri(), 'cache_page')) {
        require_once './includes/module.inc';
        bootstrap_invoke_all('init');
        if (_pdatheme_modified($cache->created)) {
          $headers = explode("\n", $cache->headers);
          foreach ($headers as $header) {
            header($header);
          }
          _pdatheme_cache_header($cache->created);
          print $cache->data;
        }
        else {
          header('HTTP/1.1 304 Not Modified');
        }
        bootstrap_invoke_all('exit');
        exit;
      }
    }
  }
}

function _pdatheme_cache_header($mtime, $cache = NULL) {
  header('Last-Modified: '. gmdate('D, d M Y H:i:s', $mtime). ' GMT');
  if (isset($cache)) {
    header('Expires: '. gmdate('D, d M Y H:i:s', time() + $cache). ' GMT');
    header('Cache-Control: must-revalidate,max-age='. $cache);
  }
  else {
    header("Expires: Sun, 19 Nov 1978 05:00:00 GMT");
    header('Cache-Control: must-revalidate');
  }
}

function _pdatheme_modified($mtime) {
  if (empty($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
    return TRUE;
  }
  $h = stripslashes($_SERVER['HTTP_IF_MODIFIED_SINCE']);
  $time = -1;
  if (preg_match('/^\s*[a-z]+,\s*\d+(\s+|-)[a-z]+(\s+|-)\d+\s+\d+:\d+:\d+\s+\w+/i', $h, $m)) {
    $time = strtotime($m[0]);
  }
  elseif (preg_match('/^\s*[a-z]+\s+[a-z]+\s+\d+\s+\d+:\d+:\d+\s+\d+\b/i', $h, $m)) {
    $time = strtotime($m[0] .' GMT');
  }
  return $mtime > $time;
}
