<?php
// $Id: pdatheme.image.inc,v 1.1 2007/10/01 14:48:22 z0rac Exp $

include_once PDATHEME_PATH .'/pdatheme.theme.inc';

function _pdatheme_show_image($path, $max = 80) {
  global $base_url;
  $file = _pdatheme_image_file($path);
  if (!_pdatheme_modified(@filemtime($file))) {
    header('HTTP/1.1 304 Not Modified');
    exit;
  }
  if ($info = _pdatheme_image_info($file)) {
    if (_pdatheme_accept_image($info['mime']) && $info[0] <= $max && $info[1] <= $max) {
      if ($fd = fopen($file, 'rb')) {
        header('Content-Type: '. $info['mime']);
        _pdatheme_cache_header(@filemtime($file), 3600);
        fpassthru($fd);
      }
      else {
        header('HTTP/1.1 403 Forbidden');
      }
      exit;
    }
    _pdatheme_image_convert($file, $info, $max);
  }
  header('Location: '. $base_url .'/'. $path);
  exit;
}

function _pdatheme_image_file($path) {
  if (file_check_location($path, '.') && file_exists($path)) {
    return $path;
  }
  if (strpos($path, 'system/files/') === 0) {
    $file = file_create_path(substr($path, 13));
    if (file_exists($file) && variable_get('file_downloads', FILE_DOWNLOADS_PUBLIC) == FILE_DOWNLOADS_PRIVATE) {
      $headers = module_invoke_all('file_download', $path);
      if (in_array(-1, $headers)) {
        header('HTTP/1.1 403 Forbidden');
        exit;
      }
      return $file;
    }
  }
  header('HTTP/1.1 404 Not Found');
  exit;
}

function _pdatheme_image_convert($file, $info, $max = 0) {
  static $from = array(
    1 => 'imagecreatefromgif',
    2 => 'imagecreatefromjpeg',
    3 => 'imagecreatefrompng',
    15 => 'imagecreatefromwbmp',
    16 => 'imagecreatefromxbm'
  );
  if (isset($from[$info[2]]) && function_exists($from[$info[2]])) {
    $image = @$from[$info[2]]($file);
  }
  if (!empty($image)) {
    $tc = (function_exists('imageistruecolor') ? imageistruecolor($image) : ($info[2] == 2));
    if ($max && ($info[0] > $max || $info[1] > $max)) {
      if ($info[0] > $info[1]) {
        $x = $max; $y = max(intval($info[1] * $max / $info[0]), 1);
      }
      else {
        $x = max(intval($info[0] * $max / $info[1]), 1); $y = $max;
      }
      if ($tc) {
        $rs = imagecreatetruecolor($x, $y);
        imagecopyresampled($rs, $image, 0, 0, 0, 0, $x, $y, $info[0], $info[1]);
      }
      else {
        $rs = imagecreate($x, $y);
        imagepalettecopy($rs, $image);
        $bg = imagecolortransparent($image);
        if (is_integer($bg)) {
          imagefilledrectangle($rs, 0, 0, $x - 1, $y - 1, $bg);
          imagecopyresized($rs, $image, 0, 0, 0, 0, $x, $y, $info[0], $info[1]);
          imagecolortransparent($rs, $bg);
        }
        else {
          imagecopyresized($rs, $image, 0, 0, 0, 0, $x, $y, $info[0], $info[1]);
        }
      }
      $image = $rs;
    }
    if ($tc) {
      if (function_exists('imagejpeg') && _pdatheme_accept_image('image/jpeg')) {
        $type = 'jpeg';
      }
      elseif (function_exists('imagetruecolortopalette')) {
        @imagetruecolortopalette($image, TRUE, 256);
      }
    }
    if (empty($type)) {
      foreach (array('png', 'gif', 'jpeg') as $i) {
        if (function_exists('image'. $i) && _pdatheme_accept_image('image/'. $i)) {
          $type = $i;
          break;
        }
      }
    }
    if ($type) {
      header('Content-Type: image/'. $type);
      _pdatheme_cache_header(@filemtime($file), 3600);
      $func = 'image'. $type;
      @$func($image);
      exit;
    }
  }
}

function _pdatheme_accept_image($mime)
{
  static $accept;
  if (!is_array($accept)) {
    $accept = array();
    if (isset($_SERVER['HTTP_ACCEPT'])) {
      $accept = array_flip(explode(',', $_SERVER['HTTP_ACCEPT']));
    }
    foreach ((array)variable_get('pdatheme_image', array('gif', 'png', 'jpeg')) as $type) {
      $accept['image/'. $type] = TRUE;
    }
  }
  return $mime == 'image/gif';
  return isset($accept[$mime]);
}

function _pdatheme_image_info($fn) {
  if ($info = @getimagesize($fn)) {
    if (!isset($info['mime'])) {
      static $mime = array(
        '',
        'image/gif',
        'image/jpeg',
        'image/png',
        'application/x-shockwave-flash',
        'image/psd',
        'image/bmp',
        'image/tiff',
        'image/tiff',
        'application/octet-stream',
        'image/jp2',
        'application/octet-stream',
        'application/octet-stream',
        'application/x-shockwave-flash',
        'image/iff',
        'image/vnd.wap.wbmp',
        'image/xbm'
      );
      $info['mime'] = isset($mime[$info[2]]) ? $mime[$info[2]] : '';
    }
    return $info;
  }
}
