<?php
// $Id: xhtml.inc,v 1.1 2007/10/01 15:27:29 z0rac Exp $

function _pda_doctype() {
  return '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">';
}

function _pda_page($title, $body, $meta = array()) {
  global $locale;
  $output = '<?xml version="1.0" encoding="'. _pda_charset_mime_name() .'"?>'. _pda('doctype');
  $output .= '<html xmlns="http://www.w3.org/1999/xhtml" lang="'. $locale .'" xml:lang="'. $locale .'"><head>';
  foreach ($meta as $attrib) {
    $output .= '<meta'. drupal_attributes($attrib) .' />';
  }
  $output .= drupal_set_html_head() . drupal_get_css();
  $output .= '<title>'. implode(' | ', $title) .'</title>';
  $output .= '</head>'. $body .'</html>';

  return _pda_xhtml_output(_pda_xhtml_replace(_pda_xhtml_parse($output, TRUE), '_pda_replace'));
}

function _pda_replace($tag) {
  if ($tag[0] == 'a' && isset($tag[1]['id'])) {
    $tag[1]['name'] = $tag[1]['id'];
    unset($tag[1]['id']);
  }
  unset($tag[1]['title']);
  return $tag;
}

function _pda_body($content, $show_blocks = TRUE) {
  $home = drupal_is_front_page();
  $title = drupal_get_title();
  $sitename = variable_get('site_name', 'Drupal');
  $slogan = variable_get('site_slogan', '');
  $blocks = array();
  if ($show_blocks) {
    $regions = system_region_list('pda');
    if (!$home) {
      unset($regions['header']);
      unset($regions['footer']);
    }
    foreach (array_keys($regions) as $region) {
      $blocks[$region] = theme('blocks', $region);
    }
  }
  $blocks['menu'] = _pda('primary_links');

  $output = '<body>';

  if ($home) {
    $output .= '<div id="header">';
    if (theme_get_setting('toggle_name')) {
      $output .= '<h1>'. check_plain($sitename) .'</h1>';
    }
    if (theme_get_setting('toggle_logo') and $logo = theme_get_setting('logo')) {
      $output .= '<img src="'. check_url($logo) .'" alt="" />';
    }
    if (theme_get_setting('toggle_slogan') && $slogan) {
      $output .= '<h4>'. check_plain($slogan) .'</h4>';
    }
    if ($mission = filter_xss_admin(theme_get_setting('mission'))) {
      $output .= '<marquee>'. $mission .'</marquee>';
    }
    $output .= $blocks['header'];
    $output .= '</div>';
  }

  $output .= $blocks['top_content'];
  if ($title) {
    $output .= '<h2 class="header">'. $title .'</h2>';
  }
  $output .= theme('menu_local_tasks') . theme('help') . theme('status_messages');
  $output .= $content;
  $output .= pda_trackbacks();
  $output .= $blocks['bottom_content'];

  if ($home) {
    $output .= $blocks['footer'];
    $output .= $blocks['menu'];
    if ($footer = variable_get('site_footer', '')) {
      $output .= '<div id="footer">'. $footer .'</div>';
    }
  }
  else {
    $output .= $blocks['menu'];
    $output .= pda_breadcrumb(drupal_get_breadcrumb());
  }
  $output .= pda_closure() .'</body>';

  return $output;
}

function _pda_primary_links() {
  $output = '';
  foreach (array(menu_primary_links(), menu_secondary_links()) as $links) {
    if ($links) {
      if ($output) {
        $output .= theme('links', $links);
      }
      else {
        $items = _pda_encode_links($links);
        $i = 1;
        foreach ($items as $key => $item) {
          $items[$key] = $i < 10 ? _pda_accesskey($i++, $item) : _pda('icon') . $item;
        }
        $output = '<ul class="menu"><li>'. implode('</li><li>', $items) .'</li></ul>';
      }
    }
  }
  if ($output) {
    return '<div id="menu">'. $output .'</div>';
  }
}

function pda_breadcrumb($breadcrumb) {
  if ($breadcrumb) {
    return _pda_accesskey('0', implode(' > ', $breadcrumb));
  }
}

function pda_node($node, $teaser = FALSE, $page = FALSE) {
  $output = '<div class="node">';
  if (!$page) {
    $output .= '<h2 class="title">'. ($teaser ? l($node->title, 'node/'. $node->nid) : check_plain($node->title)) .'</h2>';
  }
  if (theme_get_setting('toggle_node_info_'. $node->type)) {
    $output .= _pda('author', theme('username', $node), $node->created);
  }
  if ($teaser) {
    $output .= truncate_utf8(strip_tags($node->teaser), 80, FALSE, TRUE);
  }
  else {
    $output .= $node->body;
    $links = array();
    if (module_exists('taxonomy')) {
      $links = taxonomy_link('taxonomy terms', $node);
    }
    if (!empty($node->links)) {
      $links = array_merge($links, $node->links);
    }
    $output .= theme('links', $links);
  }
  $output .= '</div>';
  return $output;
}

function pda_closure($main = 0) {
  $footer = module_invoke_all('footer', $main);
  return implode('', $footer);
}

// from pager.inc
function pda_pager($tags = array(), $limit = 10, $element = 0, $parameters = array()) {
  global $pager_total;

  if ($pager_total[$element] > 1) {
    $links = array();
    $links[] = theme('pager_first', '|<', $limit, $element, $parameters);
    $links[] = theme('pager_previous', '<', $limit, $element, 1, $parameters);
    $links[] = theme('pager_list', $limit, $element, ($tags[2] ? $tags[2] : 9), '', $parameters);
    $links[] = theme('pager_next', '>', $limit, $element, 1, $parameters);
    $links[] = theme('pager_last', '>|', $limit, $element, $parameters);
    return '<div class="pager">'. strip_tags(implode('', array_diff($links, array(''))), '<a>') .'</div>';
  }
}

function pda_pager_link() {
  $args = func_get_args();
  return ' '. call_user_func_array('theme_pager_link', $args) .' ';
}

// comment
function pda_comment($comment, $links = array()) {
  $output = '<div class="comment'. ($comment->status == COMMENT_NOT_PUBLISHED ? ' comment-unpublished' : '') .'">';
  $output .= l($comment->subject, $_GET['q'], NULL, NULL, 'comment-'. $comment->cid) . theme('mark', $comment->new);
  $output .= _pda('author', theme('username', $comment), $comment->timestamp);
  $output .= $comment->comment . theme('links', $links);
  $output .= '</div>';
  return $output;
}

// trackback
function pda_trackback($trackback, $links = array()) {
  $output = '<div class="trackback" id="trackback-'. $trackback->trid .'">';
  $output .= l($trackback->subject, $trackback->url);
  $output .= _pda('author', theme('placeholder', $trackback->name), $trackback->created);
  $output .= check_markup($trackback->excerpt) . theme('links', $links);
  $output .= '</div>';
  return $output;
}

function pda_trackbacks($trackbacks = NULL) {
  static $store;
  if ($trackbacks) {
    $store = $trackbacks;
  }
  elseif ($store) {
    $output = $store;
    $store = NULL;
    return '<div id="trackbacks"><h2 class="title">'. t('Trackbacks') .'</h2>'. $output .'</div>';
  }
}

function pda_trackback_url($url) {
}

function _pda_author($author, $date = NULL) {
  $output = '<ul class="author"><li>'. $author .'</li>';
  if (isset($date)) {
    $output .=  '<li>'. theme('placeholder', format_date($date, 'small')) .'</li>';
  }
  $output .= '</ul>';
  return $output;
}
