<?php
// $Id: chtml.inc,v 1.1 2007/10/01 15:27:29 z0rac Exp $

function _pda_colors() {
  return array(
    'link' => 'blue',
    'text' => 'black'
  );
}

function _pda_fonts() {
  return array(
    'small' => array('size' => '2'),
    'big' => array('size' => '4'),
    'strong' => array('color' => 'red'),
    'em' => array('color' => 'gray'),
    'h1' => array('size' => '4'),
    'h2' => array('size' => '3'),
    'h3' => array('size' => '3'),
    'h4' => array('size' => '2'),
    'h5' => array('size' => '2'),
    'h6' => array('size' => '2')
  );
}

function _pda_doctype() {
  return '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">';
}

function _pda_page($title, $body, $meta = array()) {
  $output = _pda('doctype') .'<html><head>';
  foreach ($meta as $attrib) {
    $output .= '<meta'. drupal_attributes($attrib) .' />';
  }
  $output .= '<meta name="CHTML" content="yes" />';
  $output .= drupal_set_html_head();
  $output .= '<title>'. implode(' | ', $title) .'</title>';
  $output .= '</head>'. $body .'</html>';

  $output = _pda_xhtml_output(_pda_xhtml_replace(_pda_xhtml_parse($output, TRUE), '_pda_replace'));
  return preg_replace(array('#\s+/>#', '#</li>#'), array('>', ''), $output);
}

function _pda_replace($tag) {
  static $fonts;
  if (!isset($fonts)) {
    $fonts = _pda('fonts');
  }
  if (isset($fonts[$tag[0]])) {
    return array('font', $fonts[$tag[0]]);
  }
  if ($tag[0] == 'a' && isset($tag[1]['id'])) {
    $tag[1]['name'] = $tag[1]['id'];
  }
  unset($tag[1]['class']);
  unset($tag[1]['title']);
  unset($tag[1]['id']);
  return $tag;
}

function _pda_body($content, $show_blocks = TRUE) {
  $home = drupal_is_front_page();
  $title = drupal_get_title();
  $sitename = variable_get('site_name', 'Drupal');
  $slogan = variable_get('site_slogan', '');
  $blocks = array();
  if ($show_blocks) {
    $regions = system_region_list('pda');
    if (!$home) {
      unset($regions['header']);
      unset($regions['footer']);
    }
    foreach (array_keys($regions) as $region) {
      $blocks[$region] = theme('blocks', $region);
    }
  }
  $blocks['menu'] = _pda('primary_links');
  if ($blocks['menu'] != '') {
    $blocks['menu'] .= '<hr />';
  }

  $output = '<body '. drupal_attributes(_pda('colors')) .'>';

  if ($home) {
    $output .= '<center>';
    if (theme_get_setting('toggle_name')) {
      $output .= '<h1>'. check_plain($sitename) .'</h1><br />';
    }
    if (theme_get_setting('toggle_logo') and $logo = theme_get_setting('logo')) {
      $output .= '<img src="'. check_url($logo) .'" alt="" /><br />';
    }
    if (theme_get_setting('toggle_slogan') && $slogan) {
      $output .= '<h4>'. check_plain($slogan) .'</h4>';
    }
    $output .= '</center>';
    if ($mission = filter_xss_admin(theme_get_setting('mission'))) {
      $output .= '<marquee>'. $mission .'</marquee>';
    }
    $output .= '<hr />';
  }
  foreach (array('header', 'top_content') as $region) {
    if (!empty($blocks[$region])) {
      $output .= $blocks[$region];
    }
  }

  if ($title) {
    $output .= '<h2>'. $title .'</h2><hr />';
  }
  $output .= theme('menu_local_tasks') . theme('help') . theme('status_messages');
  $output .= $content;
  $output .= pda_trackbacks();

  foreach (array('bottom_content', 'footer', 'menu') as $region) {
    if (!empty($blocks[$region])) {
      $output .= $blocks[$region];
    }
  }
  if ($home) {
    if ($footer = variable_get('site_footer', '')) {
      $output .= '<center>'. $footer .'</center>';
    }
  }
  else {
    $output .= pda_breadcrumb(drupal_get_breadcrumb());
  }
  $output .=  pda_closure() .'</body>';

  return $output;
}

function _pda_primary_links() {
  $output = '';
  foreach (array(menu_primary_links(), menu_secondary_links()) as $links) {
    if ($links) {
      if ($output) {
        $output .= theme('links', $links);
      }
      else {
        $items = _pda_encode_links($links);
        $i = 1;
        foreach ($items as $key => $item) {
          $items[$key] = $i < 10 ? _pda_accesskey($i++, $item) : _pda('icon') . $item;
        }
        $output = implode('<br />', $items);
      }
    }
  }
  return $output;
}

// from theme.inc
function pda_links($links, $attributes = NULL) {
  if ($links) {
    return '<div><small>'. implode(' | ', _pda_encode_links($links)) .'</small></div>';
  }
}

function pda_breadcrumb($breadcrumb) {
  if ($breadcrumb) {
    return _pda_accesskey('0', implode(' > ', $breadcrumb));
  }
}

function pda_help() {
  $help = trim(menu_get_active_help());
  if (strip_tags($help)) {
    return '<div>'. $help .'</div><hr />';
  }
}

function pda_node($node, $teaser = FALSE, $page = FALSE) {
  $output = '';
  if (!$page) {
    $output .= '<h2>'. ($teaser ? l($node->title, 'node/'. $node->nid) : check_plain($node->title)) .'</h2>';
  }
  if (theme_get_setting('toggle_node_info_'. $node->type)) {
    $output .= _pda('author', theme('username', $node), $node->created);
  }
  if ($teaser) {
    $output .= truncate_utf8(strip_tags($node->teaser), 80, FALSE, TRUE);
  }
  else {
    $output .= $node->body;
    $links = array();
    if (module_exists('taxonomy')) {
      $links = taxonomy_link('taxonomy terms', $node);
    }
    if (!empty($node->links)) {
      $links = array_merge($links, $node->links);
    }
    if ($links) {
      $output .= '<br />'. pda_links($links);
    }
  }
  return $output .'<hr />';
}

function pda_block($block) {
  return '<h2>'. $block->subject .'</h2><div>'. $block->content .'</div><hr />';
}

function pda_more_help_link($url) {
  return '<div align="right"><small>' . t('[<a href="@link">more help...</a>]', array('@link' => check_url($url))) . '</small></div>';
}

function pda_closure($main = 0) {
  $footer = module_invoke_all('footer', $main);
  return implode('', $footer);
}

// from menu.inc
function pda_menu_local_tasks() {
  $output = '';
  if ($menu = menu_primary_local_tasks()) {
    $output .= $menu .'|<br />';
  }
  if ($menu = menu_secondary_local_tasks()) {
    $output .= '<small>'. $menu .'|</small><br />';
  }
  return $output;
}

function pda_menu_local_task($mid, $active, $primary) {
  if ($active) {
    return '|['. menu_item_link($mid) .']';
  }
  return '| '. menu_item_link($mid) .' ';
}

// from pager.inc
function pda_pager($tags = array(), $limit = 10, $element = 0, $parameters = array()) {
  global $pager_total;

  if ($pager_total[$element] > 1) {
    $links = array();
    $links[] = theme('pager_first', '|<', $limit, $element, $parameters);
    $links[] = theme('pager_previous', '<', $limit, $element, 1, $parameters);
    $links[] = theme('pager_list', $limit, $element, ($tags[2] ? $tags[2] : 9), '', $parameters);
    $links[] = theme('pager_next', '>', $limit, $element, 1, $parameters);
    $links[] = theme('pager_last', '>|', $limit, $element, $parameters);
    return '<center>'. strip_tags(implode('', array_diff($links, array(''))), '<a>') .'</center><hr />';
  }
}

function pda_pager_link() {
  $args = func_get_args();
  return ' '. call_user_func_array('theme_pager_link', $args) .' ';
}

// comment
function pda_comment($comment, $links = array()) {
  $output = l($comment->subject, $_GET['q'], NULL, NULL, 'comment-'. $comment->cid) . theme('mark', $comment->new);
  $output .= _pda('author', theme('username', $comment), $comment->timestamp);
  $output .= $comment->comment . pda_links($links);
  return $output .'<hr />';
}

// trackback
function pda_trackback($trackback, $links = array()) {
  $output .= l($trackback->subject, $trackback->url);
  $output .= _pda('author', theme('placeholder', $trackback->name), $trackback->created);
  $output .= check_markup($trackback->excerpt) . pda_links($links);
  return $output .'<hr />';
}

function pda_trackbacks($trackbacks = NULL) {
  static $store;
  if ($trackbacks) {
    $store = $trackbacks;
  }
  elseif ($store) {
    $output = $store;
    $store = NULL;
    return '<h2>'. t('Trackbacks') .'</h2><hr />'. $output;
  }
}

function pda_trackback_url($url) {
}

function _pda_author($author, $date = NULL) {
  $output = '<div align="right"><small>'. $author;
  if (isset($date)) {
    $output .= '<br />'. theme('placeholder', format_date($date, 'small'));
  }
  $output .= '</small></div>';
  return $output;
}
