<?php
// $Id: locale_ex.modules.inc,v 1.1.4.1 2007/07/27 18:33:23 z0rac Exp $

/*
 * Page handler for the localization of modules screen
 */
function locale_ex_modules(&$form_state) {
  $options['drupal'] = 'Drupal';
  $form['desc']['drupal'] = array('#value' => t('Drupal core system.'));

  $files = file_scan_directory('profiles', '.+\.profile$', array('.', '..', 'CVS'), 0, TRUE, 'name', 1);
  ksort($files);
  foreach ($files as $file) {
    $key = $file->filename;
    $options[$key] = $file->name;
    $form['desc'][$key] = array(
      '#value' => t('Installation profile %name.', array('%name' => $file->name))
    );
  }

  $projects = array();
  $files = drupal_system_listing('\.module$', 'modules', 'name', 0);
  ksort($files);
  foreach ($files as $file) {
    if ($info = drupal_parse_info_file(dirname($file->filename) .'/'. $file->name .'.info')) {
      if (preg_match('"^((?:[^/]*/)*modules/([^/]*))"', $file->filename, $path)) {
        $projects[$path[1]][$file->name] = $info;
      }
    }
  }
  $form['projects'] = array('#type' => 'value', '#value' => $projects);

  foreach ($projects as $key => $modules) {
    $options[$key] = basename($key);
    if (count($modules) > 1) {
      foreach ($modules as $info) {
        $form['desc'][$key][] = array(
          'name' => array('#value' => $info['name']),
          'desc' => array('#value' => t($info['description']))
        );
      }
      $info = $modules[$options[$key]];
    }
    else {
      $info = current($modules);
    }
    if ($info) {
      $options[$key] = $info['name'];
      $form['desc'][$key]['#value'] = t($info['description']);
    }
  }

  $form['module'] = array(
    '#type' => 'radios',
    '#default_value' => key($options),
    '#options' => $options
  );
  $languages = array_map('t', locale_language_list());
  unset($languages['en']);
  if ($languages) {
    $form['langcode'] = array(
      '#type' => 'select',
      '#title' => t('Language name'),
      '#default_value' => key($languages),
      '#options' => array('' => t('<none>')) + $languages,
      '#description' => t('Select the language you would like to export in gettext Portable Object (.po) format. If you select <em>&lt;none&gt;</em>, a gettext Portable Object Template (.pot) file will be generated.')
    );
  }

  $form['buttons']['submit'] = array('#type' => 'submit', '#value' => t('Extract'));
  $form['buttons']['validate'] = array('#type' => 'submit', '#value' => t('Validate'));
  return $form;
}

/*
 * Process the localization of modules submissions.
 */
function locale_ex_modules_submit($form_id, &$form_state) {
  $values = $form_state['values'];
  if ($module = $values['module']) {
    $installer = FALSE;
    if ($module == 'drupal') {
      $files = _locale_ex_core_files();
    }
    elseif (file_exists($module)) {
      if (is_dir($module)) {
        $files = _locale_ex_grab($module, 'module|install|info');
        $module = basename($module);
      }
      elseif (preg_match('/\.module$/', $module)) {
        $dir = dirname($module);
        $files = array($module);
        $module = basename($module, '.module');
        foreach (array('install', 'info') as $suffix) {
          $file = "$dir/$module.$suffix";
          if (file_exists($file)) {
            $files[] = $file;
          }
        }
      }
      else {
        $module = dirname($module);
        $files = _locale_ex_grab($module, 'profile|module|install');
        $files += _locale_ex_core_files(FALSE);
        $installer = TRUE;
        $module = basename($module);
      }
    }
    if ($files) {
      include_once 'locale_ex.extract.inc';
      if ($values['op'] == $values['submit']) {
        _locale_ex_extract_export($module, $files, $installer, $values['langcode']);
        exit;
      }
      _locale_ex_extract_verify($module, $files, $installer, $values['langcode']);
    }
    $form_state['redirect'] = FALSE;
  }
}

function theme_locale_ex_modules($form) {
  $header = array(t('Name'), t('Description'));
  $projects = $form['projects']['#value'];
  $value = isset($projects[$form['module']['#value']]) ? $form['module']['#value'] : '';

  foreach (element_children($form['module']) as $key) {
    if (isset($projects[$key])) {
      $info = $projects[$key][basename($key)];
      if (!$info) {
        $info = current($projects[$key]);
      }
      $group = isset($info['package']) ? $info['package'] : 'Other';
      $packages[$group][$key] = isset($info['project']) ? $info['project'] : '';
    }
    else {
      $rows[] = array(
        drupal_render($form['module'][$key]),
        array('data' => drupal_render($form['desc'][$key]), 'class' => 'description')
      );
    }
  }
  $output = theme('table', $header, $rows, array('class' => 'package'));
  ksort($packages);
  foreach ($packages as $name => $keys) {
    $collapsed = TRUE;
    $rows = array();
    foreach ($keys as $key => $project) {
      $desc = '';
      $modules =& $form['desc'][$key];
      foreach (element_children($modules) as $i) {
        $desc .= '<dt>'. drupal_render($modules[$i]['name']) .'</dt>';
        $desc .= '<dd><div class="description">';
        $desc .= drupal_render($modules[$i]['desc']);
        $desc .= '</div></dd>';
      }
      if ($desc) {
        $fieldset = array(
          '#title' => t('Modules of this project'),
          '#collapsible' => TRUE,
          '#collapsed' => $key != $value,
          '#value' => '<dl>'. $desc .'</dl>'
        );
        $desc = theme('fieldset', $fieldset);
      }
      if (isset($form['desc'][$key]['#value'])) {
        $desc = '<div class="description">'. drupal_render($form['desc'][$key]) .'</div>'. $desc;
      }
      $rows[] = array(drupal_render($form['module'][$key]), $desc);
      if ($collapsed) {
        $collapsed = $value ? ($key != $value) : ($project == 'drupal');
      }
    }
    $fieldset = array(
      '#title' => t($name),
      '#collapsible' => TRUE,
      '#collapsed' => $collapsed,
      '#value' => theme('table', $header, $rows, array('class' => 'package'))
    );
    $output .= theme('fieldset', $fieldset);
  }
  $output .= drupal_render($form);
  return $output;
}

function _locale_ex_grab($dir, $ext = '') {
  $files = array();
  if (is_dir($dir)) {
    $files = array_keys(file_scan_directory($dir, '.+\.(php|inc'. ($ext ? "|$ext" : '') .')$'));
  }
  return $files;
}

/*
 * Make list of Drupal's core files.
 */
function _locale_ex_core_files($all = TRUE) {
  $modules = array(
    'actions', 'aggregator', 'block', 'blog', 'blogapi', 'book', 'color', 'comment', 'contact',
    'dblog', 'drupal', 'filter', 'forum', 'help', 'locale', 'menu', 'node', 'openid', 'path',
    'php', 'ping', 'poll', 'profile', 'search', 'statistics', 'syslog', 'system', 'taxonomy',
    'throttle', 'tracker', 'translation', 'update', 'upload', 'user'
  );
  $files = array();
  foreach ($modules as $name) {
    $files = array_merge($files, _locale_ex_grab("modules/$name", 'module|install|info'));
  }
  $files = array_merge($files, _locale_ex_grab('includes'), array('cron.php', 'install.php'));
  if ($all) {
    $themes = array('bluemarine', 'chameleon', 'garland', 'pushbutton', 'engines/phptemplate');
    foreach ($themes as $name) {
      $files = array_merge($files, _locale_ex_grab("themes/$name", 'theme|engine'));
    }
  }
  return $files;
}
