/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.layout;

import java.util.Arrays;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetServiceBase;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.layout.ColumnConfigDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnConfigWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;

public class WsColumnConfig extends WidgetServiceBase {

	private String fieldString = "ColumnConfig ";

	private String instanceString = " = new ColumnConfig();";

	private String tag = "gxCLMC";

	public WsColumnConfig(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new ColumnConfigDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public String getLabel() {
		return "ColumnConfig";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	@Override
	public Component getInstance(String constracter, Map map) {
		String s = constracter.trim();
		int i = s.indexOf('(');
		if (getInstanceString().indexOf(s.substring(0, i)) >= 0) {
			return new ColumnConfigWidget(new ColumnConfig(), null);
		}
		return null;
	}

	public Component getInstance() {
		return baseDelegate.getInstance();
	}

}
