/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.comp;

import java.util.Arrays;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.TreeDelegate;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.tree.Tree;
import com.extjs.gxt.ui.client.widget.tree.TreeItem;

public class WsTreeSample extends WsTree {

	private String fieldString = "Tree ";

	private String instanceString = " = new Tree();";

	private String tag = "gxTR";

	public WsTreeSample(Component widget) {
		super(widget);
		this.widget = widget;
		baseDelegate = new TreeDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public Component getInstance() {
		return new Tree();
	}

	public String getLabel() {
		return "TreeSample";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}


	@Override
	public Component setInitStyle(Component widget) {
		Tree tree = (Tree) widget;
		TreeItem family = new TreeItem("Family");
		tree.getRootItem().add(family);
		family.add(newItem("Darrell", "user"));
		family.add(newItem("Maro", "user-girl"));
		family.add(newItem("Lia", "user-kid"));
		family.add(newItem("Alec", "user-kid"));
		family.setExpanded(true);
		return tree;
	}

	private TreeItem newItem(String text, String iconStyle) {
		TreeItem item = new TreeItem(text);
		item.setIconStyle(iconStyle);
		return item;
	}

	@Override
	public String getCategory() {
		return "Panel/Sample";
	}

}
