/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.comp;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetServiceBase;
import jp.co.kpscorp.gwt.client.design.delegate.Delegate;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.TreeDelegate;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.tree.Tree;

public class WsTree extends WidgetServiceBase {

	private String fieldString = "Tree ";

	private String instanceString = " = new Tree();";

	private String tag = "gxTR";

	public WsTree(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new TreeDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public Component getInstance() {
		return new Tree();
	}

	public String getLabel() {
		return "Tree";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	@Override
	public List<String>[] makeSource(List<String>[] lists,
			Map<Object, Object> map) {
		String fn = GxtUtil.getFieldName(lists[0], getFieldString(), getTag());
		// RootTreeItem作成
		WsTreeItem wst = new WsTreeItem(null);
		String fnti = GxtUtil.getFieldName(lists[0], wst.getFieldString(), wst
				.getTag());
		lists[0].add(getFieldString() + fn + ";");
		lists[0].add(wst.getFieldString() + fnti + ";");
		lists[1].add(fn + getInstanceString());
		lists[1].add(fnti + " = " + fn + ".getRootItem();");
		Tree tree = (Tree) this.widget;
		map.put(tree.getRootItem(), fnti);
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			delegate.makeSetterCode(widget, lists, getFieldString(),
					getInstanceString(), getTag(), fn, map);
		}
		return GxtUtil.makeAddCode(widget, lists, map, fn);
	}

}
