/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.comp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetServiceBase;
import jp.co.kpscorp.gwt.client.design.delegate.Delegate;
import jp.co.kpscorp.gwt.client.design.gxt.DesignStore;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.GridDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnModelWidget;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.Grid;

public class WsGrid extends WidgetServiceBase {

	private String fieldString = "Grid ";

	private String instanceString = " = new Grid(new ListStore(),%1);";

	private String tag = "gxGD";

	public WsGrid(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new GridDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public Component getInstance() {
		return baseDelegate.getInstance();
	}

	public String getLabel() {
		return "GridSample";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	// @Override
	// public boolean isClickResize() {
	// return false;
	// }

	@Override
	public List<String>[] makeSource(List<String>[] lists,
			Map<Object, Object> map) {
		String fn = GxtUtil.getFieldName(lists[0], getFieldString(), getTag());
		lists[0].add(getFieldString() + fn + ";");
		List<String> l = new ArrayList<String>();
		List<String>[] lists2 = new List[2];
		lists2[0] = lists[0];
		lists2[1] = l;
		l.add(fn + getInstanceString());
		Iterator it = getDelegates().iterator();
		while (it.hasNext()) {
			Delegate delegate = (Delegate) it.next();
			delegate.makeSetterCode(widget, lists2, getFieldString(),
					getInstanceString(), getTag(), fn, map);
		}
		GxtUtil.makeAddCode(widget, lists2, map, fn);
		map.put(fn + "_Grid", l);
		return lists;
	}

	@Override
	public Component getInstance(String constracter, Map map) {
		int st = constracter.indexOf("Grid(");
		if (st == -1) {
			return null;
		}
		int ed = constracter.lastIndexOf(")");
		List l = GxtUtil.devideStr(constracter.substring(st + 6, ed), ',');
		ColumnModelWidget cmw = (ColumnModelWidget) map.get(l.get(1));
		DesignStore store = new DesignStore(cmw.getWrapModel(), -1);
		Grid<ModelData> grid = new Grid<ModelData> (store, cmw.getWrapModel());
		store.setGrid(grid);
		return grid;
	}
}
