/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.comp;

import java.util.Arrays;

import jp.co.kpscorp.gwt.client.design.WidgetServiceBase;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.FormPanelDelegate;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;


public class WsFlowLayoutFormPanel extends WidgetServiceBase {

	private String fieldString = "FormPanel ";

	private String instanceString = " = new FormPanel();";

	private String tag = "gxFPS";

	public WsFlowLayoutFormPanel(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new FormPanelDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	public Component getInstance() {
		FormPanel fp = new FormPanel();
		return fp;
	}

	public String getLabel() {
		return "FlowLayoutFormPanel";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	@Override
	public Component setInitStyle(Component widget) {
		FormPanel fp = (FormPanel) widget;
		fp.setLayout(new FlowLayout());
		fp.setBorders(true);
		fp.setWidth(700);
		fp.setHeight(300);
		return widget;
	}
	
	



}
