/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.comp;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetServiceBase;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.ButtonBarDelegate;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;

public class WsButtonBar extends WidgetServiceBase {

	private String fieldString = "ButtonBar ";

	private String instanceString = " = new ButtonBar();";

	private String tag = "gxBTB";

	private ButtonBar comp;

	public WsButtonBar(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new ButtonBarDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
		this.comp = (ButtonBar) widget;
	}

	public Component getInstance() {
		return new ButtonBar();
	}

	public String getLabel() {
		return "ButtonBar";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

	@Override
	public List<String>[] makeSource(List<String>[] lists,
			Map<Object, Object> map) {
		// 空のButtonBarは無視
		if (comp.getItemCount() > 0) {
			return super.makeSource(lists, map);
		}
		return lists;
	}

}
