/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.service.comp;

import java.util.Arrays;

import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.AdapterToolItemDelegate;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.toolbar.AdapterToolItem;
import com.google.gwt.user.client.ui.Widget;

public class WsAdapterToolItem extends WsAdapterBase {

	private String fieldString = "AdapterToolItem ";

	private String instanceString = " = new AdapterToolItem(%1);";

	private String tag = "gxATI";

	public WsAdapterToolItem(Component widget) {
		super();
		this.widget = widget;
		baseDelegate = new AdapterToolItemDelegate(this, widget);
		delegates.add(baseDelegate);
		props = Arrays.asList(baseDelegate.getProps());
		innerProps = Arrays.asList(baseDelegate.getInnerProps());
	}

	protected Component getInstance(Widget widget) {
		return new AdapterToolItem(widget);
	}

	public String getLabel() {
		return "AdapterToolItem";
	}

	public String getTag() {
		return tag;
	}

	public String getFieldString() {
		return fieldString;
	}

	public String getInstanceString() {
		return instanceString;
	}

}
