/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.model;

import java.util.Date;
import java.util.Set;

import jp.co.kpscorp.gwt.client.design.gxt.common.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.common.LabelModel;

import com.extjs.gxt.ui.client.data.BeanModelTag;
import com.google.gwt.user.client.rpc.IsSerializable;

public class Lease implements IsSerializable, BeanModelTag, LabelModel {

	private static final String[][] labels = { { "updTime", "UpdateTime" },
			{ "leasePk", "リース契約PK" }, { "leaseNo", "リース契約No." },
			{ "leaseContractDate", "リース契約日" }, { "leaseCompany", "リース契約会社" },
			{ "leasePeriodStartday", "リース開始日" },
			{ "leasePeriodEndday", "リース満了日" } };

	public String label(String prop) {
		return GxtUtil.prop2Label(prop, labels);
	}

	/** identifier field */
	private Integer leasePk;

	/** persistent field */
	private String leaseNo;

	/** nullable persistent field */
	private Date leaseContractDate;

	/** nullable persistent field */
	private String leaseCompany;

	/** persistent field */
	private Date leasePeriodStartday;

	/** persistent field */
	private Date leasePeriodEndday;

	/** nullable persistent field */
	private Date updTime;

	/** persistent field */
	private Set machines;

	public Lease() {
	}

	public Lease(Lease lease) {
		super();
		this.leasePk = null;
		this.leaseNo = lease.getLeaseNo();
		this.leaseContractDate = lease.getLeaseContractDate();
		this.leaseCompany = lease.getLeaseCompany();
		this.leasePeriodStartday = lease.getLeasePeriodStartday();
		this.leasePeriodEndday = lease.getLeasePeriodEndday();
		this.updTime = lease.getUpdTime();
		this.machines = lease.getMachines();
	}

	public Integer getLeasePk() {
		return leasePk;
	}

	public void setLeasePk(Integer leasePk) {
		this.leasePk = leasePk;
	}

	public String getLeaseNo() {
		return leaseNo;
	}

	public void setLeaseNo(String leaseNo) {
		this.leaseNo = leaseNo;
	}

	public Date getLeaseContractDate() {
		return leaseContractDate;
	}

	public void setLeaseContractDate(Date leaseContractDate) {
		this.leaseContractDate = leaseContractDate;
	}

	public String getLeaseCompany() {
		return leaseCompany;
	}

	public void setLeaseCompany(String leaseCompany) {
		this.leaseCompany = leaseCompany;
	}

	public Date getLeasePeriodStartday() {
		return leasePeriodStartday;
	}

	public void setLeasePeriodStartday(Date leasePeriodStartday) {
		this.leasePeriodStartday = leasePeriodStartday;
	}

	public Date getLeasePeriodEndday() {
		return leasePeriodEndday;
	}

	public void setLeasePeriodEndday(Date leasePeriodEndday) {
		this.leasePeriodEndday = leasePeriodEndday;
	}

	public Date getUpdTime() {
		return updTime;
	}

	public void setUpdTime(Date updTime) {
		this.updTime = updTime;
	}

	public Set getMachines() {
		return machines;
	}

	public void setMachines(Set machines) {
		this.machines = machines;
	}

	public String getLabel() {
		return null;
	}

	public String getValue() {
		return null;
	}

	public int compareTo(Object o) {
		return 0;
	}

}
