/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;


import jp.co.kpscorp.gwt.client.design.DesignPanel;
import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.TableDataWidget;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.Style.VerticalAlignment;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.LayoutContainerHelper;
import com.extjs.gxt.ui.client.widget.layout.TableData;


public class TableDataDelegate extends LayoutDataDelegate {

	private TableDataWidget comp;

	protected String[] props = { "width", "horizontalAlign", "height",
			"verticalAlign", "padding", "style", "colspan", "styleName",
			"margin" };

	public TableDataDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TableDataWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getColspan".equals(mthodName)) {
			return comp.getColspan();
		} else if ("getHeight".equals(mthodName)) {
			return comp.getHeight();
		} else if ("getHorizontalAlign".equals(mthodName)) {
			return comp.getHorizontalAlign();
		} else if ("getMargin".equals(mthodName)) {
			return comp.getMargin();
		} else if ("getPadding".equals(mthodName)) {
			return comp.getPadding();
		} else if ("getStyle".equals(mthodName)) {
			return comp.getStyle();
		} else if ("getStyleName".equals(mthodName)) {
			return comp.getStyleName();
		} else if ("getVerticalAlign".equals(mthodName)) {
			return comp.getVerticalAlign();
		} else if ("getWidth".equals(mthodName)) {
			return comp.getWidth();
		} else if ("setColspan".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setColspan(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setHeight".equals(mthodName) && parms[0] instanceof String) {
			comp.setHeight((String) parms[0]);
			return comp;
		} else if ("setHorizontalAlign".equals(mthodName)
				&& parms[0] instanceof HorizontalAlignment) {
			comp.setHorizontalAlign((HorizontalAlignment) parms[0]);
			return comp;
		} else if ("setMargin".equals(mthodName) && GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMargin(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setPadding".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setPadding(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setStyle".equals(mthodName) && parms[0] instanceof String) {
			comp.setStyle((String) parms[0]);
			return comp;
		} else if ("setStyleName".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setStyleName((String) parms[0]);
			return comp;
		} else if ("setVerticalAlign".equals(mthodName)
				&& parms[0] instanceof VerticalAlignment) {
			comp.setVerticalAlign((VerticalAlignment) parms[0]);
			return comp;
		} else if ("setWidth".equals(mthodName) && parms[0] instanceof String) {
			comp.setWidth((String) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	public static void setTableDataSize(Component comp) {
		if (ComponentHelper.getLayoutData(comp) != null
				&& ComponentHelper.getLayoutData(comp) instanceof TableData) {
			TableData td = (TableData) ComponentHelper.getLayoutData(comp);
			if (comp.getParent() != null
					&& comp.getParent() instanceof LayoutContainer) {
				LayoutContainer lc = (LayoutContainer) comp.getParent();
				td.setHeight(LayoutContainerHelper.getHeight(lc));
				td.setWidth(LayoutContainerHelper.getWidth(lc));
				DesignPanel.getInstance().getBasePanel().layout();
			}
		}
	}

}
