/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.ComponentDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.widget.LayoutWidget;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;

public class LayoutDelegate extends ComponentDelegate {

	private LayoutWidget comp;

	protected String[] props = { "extraStyle", "renderHidden", "resizeDelay",
			"firesEvents" };

	public LayoutDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (LayoutWidget) widget;
	}

	@Override
	public String[] getProps() {
		return props;
	}

	// Layoutはpropsと同じ
	@Override
	public String[] getInnerProps() {
		return getProps();
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getExtraStyle".equals(mthodName)) {
			return comp.getExtraStyle();
		} else if ("getResizeDelay".equals(mthodName)) {
			return comp.getResizeDelay();
		} else if ("isRenderHidden".equals(mthodName)) {
			return comp.isRenderHidden();
		} else if ("setExtraStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setExtraStyle((String) parms[0]);
			return comp;
		} else if ("setRenderHidden".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setRenderHidden((Boolean) parms[0]);
			return comp;
		} else if ("setResizeDelay".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setResizeDelay(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("getFiresEvents".equals(mthodName)) {
			return comp.getFiresEvents();
		} else if ("setFiresEvents".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setFiresEvents((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		return false;
	}

	public void resetLayoutWhenAdd(Component addComp) {
	}

	public LayoutData getValidLayoutData() {
		return null;
	}

}
