/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;

import java.util.List;
import java.util.Map;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.delegate.comp.GridDelegate;
import jp.co.kpscorp.gwt.client.design.gxt.service.layout.WsColumnModel;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnConfigWidget;
import jp.co.kpscorp.gwt.client.design.gxt.widget.ColumnModelWidget;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.CellEditor;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;

public class ColumnConfigDelegate extends ConfigDelegate {

	private ColumnConfigWidget comp;

	protected String[] props = { "dateTimeFormat", "width", "groupable",
			"numberFormat", "renderer", "menuDisabled", "header", "alignment",
			"fixed", "id", "firesEvents", "resizable", "hidden", "style",
			"dataIndex", "sortable" };
	protected String[] innerProps = { "dateTimeFormat", "width",
			"numberFormat", "renderer", "groupable", "menuDisabled", "header",
			"alignment", "fixed", "id", "editor", "firesEvents", "resizable",
			"hidden", "style", "dataIndex", "sortable", "parent" };

	public ColumnConfigDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (ColumnConfigWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getParent".equals(mthodName)) {
			return comp.getParent();
		} else if ("getId".equals(mthodName)) {
			return comp.getId();
		} else if ("setParent".equals(mthodName)
				&& parms[0] instanceof ColumnModelWidget) {
			comp.setParent((ColumnModelWidget) parms[0]);
			return comp;
		} else if ("isHidden".equals(mthodName)) {
			return comp.isHidden();
		} else if ("getAlignment".equals(mthodName)) {
			return comp.getAlignment();
		} else if ("getDataIndex".equals(mthodName)) {
			return comp.getDataIndex();
		} else if ("getDateTimeFormat".equals(mthodName)) {
			return comp.getDateTimeFormat();
		} else if ("getEditor".equals(mthodName)) {
			return comp.getEditor();
		} else if ("getFiresEvents".equals(mthodName)) {
			return comp.getFiresEvents();
		} else if ("getHeader".equals(mthodName)) {
			return comp.getHeader();
		} else if ("getNumberFormat".equals(mthodName)) {
			return comp.getNumberFormat();
		} else if ("getRenderer".equals(mthodName)) {
			return comp.getRenderer();
		} else if ("getStyle".equals(mthodName)) {
			return comp.getStyle();
		} else if ("getWidth".equals(mthodName)) {
			return comp.getWidth();
		} else if ("isFixed".equals(mthodName)) {
			return comp.isFixed();
		} else if ("isGroupable".equals(mthodName)) {
			return comp.isGroupable();
		} else if ("isMenuDisabled".equals(mthodName)) {
			return comp.isMenuDisabled();
		} else if ("isResizable".equals(mthodName)) {
			return comp.isResizable();
		} else if ("isSortable".equals(mthodName)) {
			return comp.isSortable();
		} else if ("setAlignment".equals(mthodName)
				&& parms[0] instanceof HorizontalAlignment) {
			comp.setAlignment((HorizontalAlignment) parms[0]);
			return comp;
		} else if ("setDataIndex".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setDataIndex((String) parms[0]);
			return comp;
		} else if ("setDateTimeFormat".equals(mthodName)
				&& parms[0] instanceof DateTimeFormat) {
			comp.setDateTimeFormat((DateTimeFormat) parms[0]);
			return comp;
		} else if ("setDateTimeFormat".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setDateTimeFormat(GxtUtil
					.makeDateTimeFormat((String) parms[0]));
			return comp;
		} else if ("setEditor".equals(mthodName)
				&& parms[0] instanceof CellEditor) {
			comp.setEditor((CellEditor) parms[0]);
			return comp;
		} else if ("setFiresEvents".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setFiresEvents((Boolean) parms[0]);
			return comp;
		} else if ("setFixed".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setFixed((Boolean) parms[0]);
			return comp;
		} else if ("setGroupable".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setGroupable((Boolean) parms[0]);
			return comp;
		} else if ("setHeader".equals(mthodName) && parms[0] instanceof String) {
			comp.setHeader((String) parms[0]);
			return comp;
		} else if ("setHidden".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setHidden((Boolean) parms[0]);
			return comp;
		} else if ("setId".equals(mthodName) && parms[0] instanceof String) {
			comp.setId((String) parms[0]);
			return comp;
		} else if ("setMenuDisabled".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setMenuDisabled((Boolean) parms[0]);
			return comp;
		} else if ("setNumberFormat".equals(mthodName)
				&& parms[0] instanceof NumberFormat) {
			comp.setNumberFormat((NumberFormat) parms[0]);
			return comp;
		} else if ("setNumberFormat".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setNumberFormat(GxtUtil.makeNumberFormat((String) parms[0]));
			return comp;
		} else if ("setRenderer".equals(mthodName)
				&& parms[0] instanceof GridCellRenderer) {
			comp.setRenderer((GridCellRenderer) parms[0]);
			return comp;
		} else if ("setResizable".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setResizable((Boolean) parms[0]);
			return comp;
		} else if ("setSortable".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setSortable((Boolean) parms[0]);
			return comp;
		} else if ("setStyle".equals(mthodName) && parms[0] instanceof String) {
			comp.setStyle((String) parms[0]);
			return comp;
		} else if ("setWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("getWrapConfig".equals(mthodName)) {
			return comp.getWrapConfig();
		}
		return null;
	}

	@Override
	public String[] getProps() {
		return props;
	}

	@Override
	public String[] getInnerProps() {
		return innerProps;
	}

	@Override
	public String getAddCode(Component widget, List[] lists,
			String parentFiledName, String fieldName, Map map) {
		return parentFiledName + "_l.add(" + fieldName + ");";
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		return parent instanceof ColumnModelWidget
				|| parent instanceof ColumnConfigWidget
				|| parent instanceof Grid;
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof ColumnConfigWidget) {
			ColumnConfigWidget ccw = (ColumnConfigWidget) widget;
			ColumnModelWidget cmw = (ColumnModelWidget) comp.getParent();
			List<ColumnConfig> l = cmw.getConfig();
			int i = l.indexOf(comp.getWrapConfig());
			l.add(i, ccw.getWrapConfig());
			Grid grid = GridDelegate.resetColumnModel((Grid<ModelData>) cmw.getParent(),
					cmw.getWrapModel());
			cmw.setGrid(grid);
		}
	}

	@Override
	public boolean isAddable() {
		return true;
	}

	@Override
	public Component setInitStyle(Component widget) {
		ColumnConfigWidget ccw = (ColumnConfigWidget) widget;
		String s = GxtUtil.getNewTag(service.getTag());
		ccw.setId(s);
		ccw.setHeader(s);
		ccw.setWidth(100);
		return ccw;
	}

	public Component getInstance() {
		ColumnModelWidget cmw = null;
		if (widget != null) {
			cmw = (ColumnModelWidget) ((ColumnConfigWidget) widget).getParent();
		}
		if (cmw == null) {
			WsColumnModel wscm = new WsColumnModel(null);
			cmw = (ColumnModelWidget) GxtUtil.addRender(wscm.getInstance());
		}
		return new ColumnConfigWidget(new ColumnConfig(), cmw);
	}

}
