/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.BorderLayoutDataWidget;

import com.extjs.gxt.ui.client.Style.LayoutRegion;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;


public class BorderLayoutDataDelegate extends LayoutDataDelegate {

	private BorderLayoutDataWidget comp;

	protected String[] props = { "minSize", "collapsible", "maxSize",
			"margins", "floatable", "region", "size", "split" };

	public BorderLayoutDataDelegate(WidgetService service, Component widget
) {
		super(service, widget);
		this.comp = (BorderLayoutDataWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getMargins".equals(mthodName)) {
			return comp.getMargins();
		} else if ("getMaxSize".equals(mthodName)) {
			return comp.getMaxSize();
		} else if ("getMinSize".equals(mthodName)) {
			return comp.getMinSize();
		} else if ("getRegion".equals(mthodName)) {
			return comp.getRegion();
		} else if ("isCollapsible".equals(mthodName)) {
			return comp.isCollapsible();
		} else if ("isSplit".equals(mthodName)) {
			return comp.isSplit();
		} else if ("setCollapsible".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setCollapsible((Boolean) parms[0]);
			return comp;
		} else if ("setMargins".equals(mthodName)
				&& parms[0] instanceof Margins) {
			comp.setMargins((Margins) parms[0]);
			return comp;
		} else if ("setMargins".equals(mthodName) && parms[0] instanceof String) {
			comp.setMargins(GxtUtil.makeMargins((String) parms[0]));
			return comp;
		} else if ("setMaxSize".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMaxSize(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setMinSize".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMinSize(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setRegion".equals(mthodName)
				&& parms[0] instanceof LayoutRegion) {
			comp.setRegion((LayoutRegion) parms[0]);
			return comp;
		} else if ("setSplit".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setSplit((Boolean) parms[0]);
			return comp;
		} else if ("getSize".equals(mthodName)) {
			return comp.getSize();
		} else if ("setSize".equals(mthodName) && parms[0] instanceof Float) {
			comp.setSize((Float) parms[0]);
			return comp;
		} else if ("isFloatable".equals(mthodName)) {
			return comp.isFloatable();
		} else if ("setFloatable".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setFloatable((Boolean) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

}
