/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.layout;


import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;
import jp.co.kpscorp.gwt.client.design.gxt.widget.AbsoluteDataWidget;

import com.extjs.gxt.ui.client.widget.Component;

public class AbsoluteDataDelegate extends AnchorDataDelegate {

	private AbsoluteDataWidget comp;

	protected String[] props = { "top", "left" };

	public AbsoluteDataDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (AbsoluteDataWidget) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getLeft".equals(mthodName)) {
			return comp.getLeft();
		} else if ("getTop".equals(mthodName)) {
			return comp.getTop();
		} else if ("setLeft".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setLeft(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("setTop".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setTop(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

}
