/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.tips.ToolTipConfig;
import com.extjs.gxt.ui.client.widget.toolbar.TextToolItem;

public class TextToolItemDelegate extends ToolItemDelegate {

	private TextToolItem comp;

	// menu toolTip不要
	protected String[] props = { "text", "iconStyle" };

	protected String[] innerProps = { "text", "iconStyle" };

	public TextToolItemDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (TextToolItem) widget;
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("setText".equals(mthodName) && parms[0] instanceof String) {
			comp.setText((String) parms[0]);
			return comp;
		} else if ("getIconStyle".equals(mthodName)) {
			return comp.getIconStyle();
		} else if ("getMenu".equals(mthodName)) {
			return comp.getMenu();
		} else if ("getText".equals(mthodName)) {
			return comp.getText();
		} else if ("getToolBar".equals(mthodName)) {
			return comp.getToolBar();
		} else if ("getToolTip".equals(mthodName)) {
			return comp.getToolTip();
		} else if ("setIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setIconStyle((String) parms[0]);
			return comp;
		} else if ("setMenu".equals(mthodName) && parms[0] instanceof Menu) {
			comp.setMenu((Menu) parms[0]);
			return comp;
		} else if ("setToolTip".equals(mthodName)
				&& parms[0] instanceof ToolTipConfig) {
			comp.setToolTip((ToolTipConfig) parms[0]);
			return comp;
		} else if ("setToolTip".equals(mthodName) && parms[0] instanceof String) {
			comp.setToolTip((String) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof Menu) {
			if (comp.isRendered()) {
				comp = (TextToolItem) GxtUtil.addAfterRender(comp, widget);
			} else {
				comp.setMenu((Menu) widget);
			}
		}
		super.addWidget(widget);
	}

	@Override
	public List<Component> getChildren() {
		List<Component> l = super.getChildren();
		if (comp.getMenu() != null) {
			l.add(comp.getMenu());
		}
		return l;
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget == comp.getMenu()) {
			comp.setMenu(null);
		}
		return super.removeWidget(widget);
	}

	@Override
	public Component setInitStyle(Component widget) {
		TextToolItem item = (TextToolItem) widget;
		item.setText(GxtUtil.getNewTag(service.getTag()));
		return item;
	}

	@Override
	public String getAddCode(Component widget, List<String>[] lists,
			String parentFiledName, String fieldName, Map<Object, Object> map) {
		if (widget instanceof Menu) {
			return parentFiledName + ".setMenu(" + fieldName + ");";
		}
		return super.getAddCode(widget, lists, parentFiledName, fieldName, map);
	}

	@Override
	public boolean isAddable() {
		return true;
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-TT";
	}



}
