/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Shadow.ShadowPosition;
import com.extjs.gxt.ui.client.widget.menu.Item;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.toolbar.TextToolItem;

public class MenuDelegate extends ContainerDelegate {
	private Menu comp;

	protected String[] props = { "constrainViewport", "subMenuAlign",
			"shadowPosition", "defaultAlign", "minWidth" };

	protected String[] innerProps = { "constrainViewport", "subMenuAlign",
			"shadowPosition", "defaultAlign", "minWidth" };

	public MenuDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (Menu) widget;
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getDefaultAlign".equals(mthodName)) {
			return comp.getDefaultAlign();
		} else if ("getParentItem".equals(mthodName)) {
			return comp.getParentItem();
		} else if ("getShadowPosition".equals(mthodName)) {
			return comp.getShadowPosition();
		} else if ("getSubMenuAlign".equals(mthodName)) {
			return comp.getSubMenuAlign();
		} else if ("isConstrainViewport".equals(mthodName)) {
			return comp.isConstrainViewport();
		} else if ("setConstrainViewport".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setConstrainViewport((Boolean) parms[0]);
			return comp;
		} else if ("setDefaultAlign".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setDefaultAlign((String) parms[0]);
			return comp;
		} else if ("setShadowPosition".equals(mthodName)
				&& parms[0] instanceof ShadowPosition) {
			comp.setShadowPosition((ShadowPosition) parms[0]);
			return comp;
		} else if ("setSubMenuAlign".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setSubMenuAlign((String) parms[0]);
			return comp;
		} else if ("isVisible".equals(mthodName)) {
			return comp.isVisible();
		} else if ("getMinWidth".equals(mthodName)) {
			return comp.getMinWidth();
		} else if ("setMinWidth".equals(mthodName)
				&& GxtUtil.safeParseInteger(parms[0]) != null) {
			comp.setMinWidth(GxtUtil.safeParseInteger(parms[0]));
			return comp;
		} else if ("add".equals(mthodName) && parms[0] instanceof Item) {
			comp.add((Item) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof Item) {
			Item item = (Item) widget;
			if (insertIdx == -1) {
				insertIdx = comp.getItemCount();
			}
			comp.insert(item, insertIdx);
			insertIdx = -1;
		}
		super.addWidget(widget);
	}

	@Override
	public Component removeWidget(Component widget) {
		if (widget instanceof Item) {
			Item item = (Item) widget;
			comp.remove(item);
			return comp;
		}
		return super.removeWidget(widget);
	}

	@Override
	public Component setInitStyle(Component widget) {
		Menu menu = (Menu) widget;
		menu.add(GxtUtil.addRender(new MenuItem(GxtUtil.getNewTag(service
				.getTag()))));
		return menu;
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		if (parent instanceof MenuItem) {
			return true;
		} else if (parent instanceof TextToolItem) {
			return true;
		}
		return super.isAddableToParent(parent);
	}

	@Override
	public Component getParent() {
		Item item = comp.getParentItem();
		if (item != null) {
			return item;
		}
		return super.getParent();
	}

	@Override
	public String getCategory() {
		return "Tool/Menu";
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-Me";
	}



}
