/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.DataList;
import com.extjs.gxt.ui.client.widget.DataListItem;

public class DataListItemDelegate extends ComponentDelegate {

	private DataListItem comp;

	protected String[] props = { "text", "textStyle", "iconStyle", "checked" };

	protected String[] innerProps = { "text", "textStyle", "iconStyle",
			"checked" };

	public DataListItemDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (DataListItem) widget;
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getIconStyle".equals(mthodName)) {
			return comp.getIconStyle();
		} else if ("getTextStyle".equals(mthodName)) {
			return comp.getTextStyle();
		} else if ("isChecked".equals(mthodName)) {
			return comp.isChecked();
		} else if ("setChecked".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setChecked((Boolean) parms[0]);
			return comp;
		} else if ("setIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setIconStyle((String) parms[0]);
			return comp;
		} else if ("setTextStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setTextStyle((String) parms[0]);
			return comp;
		} else if ("getText".equals(mthodName)) {
			return comp.getText();
		} else if ("setText".equals(mthodName) && parms[0] instanceof String) {
			comp.setText((String) parms[0]);
			return comp;
		} else if ("getList".equals(mthodName)) {
			return comp.getList();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public Component setInitStyle(Component widget) {
		WidgetService ws = WidgetServiceFactory.getService(widget);
		DataListItem dli = (DataListItem) widget;
		dli.setText(GxtUtil.getNewTag(ws.getTag()));
		return dli;
	}

	@Override
	public boolean isAddableToParent(Component parent) {
		if (parent instanceof DataList) {
			return true;
		}
		return false;
	}

}
