/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.DesignPanel;
import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.WidgetServiceFactory;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Header;
import com.extjs.gxt.ui.client.widget.WidgetHelper;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;

public class ContentPanelDelegate extends LayoutContainerDelegate {

	private ContentPanel comp;

	protected String[] props = { "animCollapse", "bodyBorder", "bodyStyle",
			"bodyStyleName", "buttonAlign", "collapsible", "expanded",
			"footer", "frame", "headerVisible", "heading", "hideCollapseTool",
			"iconStyle", "insetBorder", "titleCollapse", "url" };

	// buttonBarはdeepcopy
	protected String[] innerProps = { "topComponent", "footer", "animCollapse",
			"bodyStyle", "headerVisible", "frame", "collapsible",
			"bottomComponent", "expanded", "iconStyle", "hideCollapseTool",
			"titleCollapse", "heading", "bodyBorder", "buttonAlign" };

	public ContentPanelDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (ContentPanel) widget;
		if (this.comp != null) {
			this.comp.getHeader().setData("parent", this.comp);
			this.comp.getButtonBar().setData("parent", this.comp);
		}
	}

	@SuppressWarnings("deprecation")
	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getAnimCollapse".equals(mthodName)) {
			return comp.getAnimCollapse();
		} else if ("getBody".equals(mthodName)) {
			return comp.getBody();
		} else if ("getBodyBorder".equals(mthodName)) {
			return comp.getBodyBorder();
		} else if ("getBodyStyle".equals(mthodName)) {
			return comp.getBodyStyle();
		} else if ("getBottomComponent".equals(mthodName)) {
			return comp.getBottomComponent();
		} else if ("getButtonAlign".equals(mthodName)) {
			return comp.getButtonAlign();
		} else if ("getButtonBar".equals(mthodName)) {
			return comp.getButtonBar();
		} else if ("getCollapsible".equals(mthodName)) {
			return comp.getCollapsible();
		} else if ("getFooter".equals(mthodName)) {
			return comp.getFooter();
		} else if ("getFrame".equals(mthodName)) {
			return comp.getFrame();
		} else if ("getFrameHeight".equals(mthodName)) {
			return comp.getFrameHeight();
		} else if ("getFrameWidth".equals(mthodName)) {
			return comp.getFrameWidth();
		} else if ("getHeader".equals(mthodName)) {
			return comp.getHeader();
		} else if ("getHeading".equals(mthodName)) {
			return comp.getHeading();
		} else if ("getIconStyle".equals(mthodName)) {
			return comp.getIconStyle();
		} else if ("getInnerHeight".equals(mthodName)) {
			return comp.getInnerHeight();
		} else if ("getInnerWidth".equals(mthodName)) {
			return comp.getInnerWidth();
		} else if ("getLayoutTarget".equals(mthodName)) {
			return comp.getLayoutTarget();
		} else if ("getTitleCollapse".equals(mthodName)) {
			return comp.getTitleCollapse();
		} else if ("getTitleText".equals(mthodName)) {
			return comp.getTitleText();
		} else if ("getTopComponent".equals(mthodName)) {
			return comp.getTopComponent();
		} else if ("isExpanded".equals(mthodName)) {
			return comp.isExpanded();
		} else if ("isHeaderVisible".equals(mthodName)) {
			return comp.isHeaderVisible();
		} else if ("isHideCollapseTool".equals(mthodName)) {
			return comp.isHideCollapseTool();
		} else if ("setAnimCollapse".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setAnimCollapse((Boolean) parms[0]);
			return comp;
		} else if ("setBodyBorder".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setBodyBorder((Boolean) parms[0]);
			return comp;
		} else if ("setBodyStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setBodyStyle((String) parms[0]);
			return comp;
		} else if ("setBodyStyleName".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setBodyStyleName((String) parms[0]);
			return comp;
		} else if ("setBottomComponent".equals(mthodName)
				&& parms[0] instanceof Component) {
			comp.setBottomComponent((Component) parms[0]);
			return comp;
		} else if ("setButtonAlign".equals(mthodName)
				&& parms[0] instanceof HorizontalAlignment) {
			comp.setButtonAlign((HorizontalAlignment) parms[0]);
			return comp;
		} else if ("setButtonBar".equals(mthodName)
				&& parms[0] instanceof ButtonBar) {
			comp.setButtonBar((ButtonBar) parms[0]);
			return comp;
		} else if ("setCollapsible".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setCollapsible((Boolean) parms[0]);
			return comp;
		} else if ("setExpanded".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setExpanded((Boolean) parms[0]);
			return comp;
		} else if ("setFooter".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setFooter((Boolean) parms[0]);
			return comp;
		} else if ("setFrame".equals(mthodName) && parms[0] instanceof Boolean) {
			comp.setFrame((Boolean) parms[0]);
			return comp;
		} else if ("setHeaderVisible".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setHeaderVisible((Boolean) parms[0]);
			return comp;
		} else if ("setHeading".equals(mthodName) && parms[0] instanceof String) {
			comp.setHeading((String) parms[0]);
			return comp;
		} else if ("setHideCollapseTool".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setHideCollapseTool((Boolean) parms[0]);
			return comp;
		} else if ("setIconStyle".equals(mthodName)
				&& parms[0] instanceof String) {
			comp.setIconStyle((String) parms[0]);
			return comp;
		} else if ("setInsetBorder".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setInsetBorder((Boolean) parms[0]);
			return comp;
		} else if ("setTitleCollapse".equals(mthodName)
				&& parms[0] instanceof Boolean) {
			comp.setTitleCollapse((Boolean) parms[0]);
			return comp;
		} else if ("setTopComponent".equals(mthodName)
				&& parms[0] instanceof Component) {
			comp.setTopComponent((Component) parms[0]);
			return comp;
		} else if ("setUrl".equals(mthodName) && parms[0] instanceof String) {
			comp.setUrl((String) parms[0]);
			return comp;
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Menu makeBar() {
		Menu bar1 = super.makeBar();
		DesignPanel dp = DesignPanel.getInstance();
		if (!dp.isBase() && !dp.isResizeMode()) {
			bar1.add(new MenuItem("addButton", "icon-menu-Btn",new AddButton()));
		}
		return bar1;
	}

	private class AddButton extends SelectionListener<ComponentEvent> {

		@Override
		public void componentSelected(ComponentEvent ce) {
			WidgetService bws = WidgetServiceFactory.getService(new Button());
			Button bt = (Button) bws.setInitStyle(bws.getInstance());
			comp = GxtUtil.addButtonAfterRender(comp, bt, comp.getButtonBar().getItemCount());
			DesignPanel.getInstance().getPop().hide();
		}
	}

	@Override
	public String getAddCode(Component widget, List[] lists,
			String parentFiledName, String fieldName, Map map) {
		if (widget instanceof ButtonBar) {
			return parentFiledName + ".setButtonBar(" + fieldName + ");";
		}
		return super.getAddCode(widget, lists, parentFiledName, fieldName, map);
	}

	@Override
	public List<Component> getChildren() {
		List<Component> l = super.getChildren();
		comp.getHeader().setData("parent", this.comp);
		comp.getButtonBar().setData("parent", this.comp);
		l.add(comp.getButtonBar());
		l.add(comp.getHeader());
		return l;
	}

	@Override
	public Component setInitStyle(Component widget) {
		ContentPanel cp = (ContentPanel) super.setInitStyle(widget);
		cp.setHeading("ContentPanel");
		return cp;
	}

	@Override
	public void addWidget(Component widget) {
		if (widget instanceof ButtonBar) {
			ButtonBar b = (ButtonBar) widget;
			if (comp.isRendered()) {
				comp = (ContentPanel) GxtUtil.addAfterRender(comp, widget);
			} else {
				comp.setButtonBar(b);
			}
			widget.setData("parent", comp);
		} else if (widget instanceof Header) {
			Header header = (Header) widget;
			if (comp.isRendered()) {
				comp = (ContentPanel) GxtUtil.addAfterRender(comp, widget);
			} else {
				WidgetHelper.setHeader(comp, header);
			}
			widget.setData("parent", comp);
		} else {
			super.addWidget(widget);
		}
	}

	@Override
	public String getCategory() {
		return "Panel/Sample";
	}

	@Override
	public Component removeWidget(Component widget) {
		if (comp.getHeader() == widget) {
			// 自分のheaderはremoveしない
			return comp;
		}
		if (comp.getButtonBar() == widget) {
			// 自分のbuttonBarはremoveしない
			return comp;
		}
		return super.removeWidget(widget);
	}

	@Override
	public String getIconStyle() {
		return "icon-menu-CP";
	}



}
