/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt.delegate.comp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.co.kpscorp.gwt.client.design.WidgetService;
import jp.co.kpscorp.gwt.client.design.gxt.GxtUtil;

import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.AdapterMenuItem;
import com.extjs.gxt.ui.client.widget.menu.MenuHelper;

public class AdapterMenuItemDelegate extends ItemDelegate {

	private AdapterMenuItem comp;

	protected String[] props = {};

	protected String[] innerProps = {};

	public AdapterMenuItemDelegate(WidgetService service, Component widget) {
		super(service, widget);
		this.comp = (AdapterMenuItem) widget;
	}

	@Override
	public String[] getInnerProps() {
		return GxtUtil.add(super.getInnerProps(), innerProps);
	}

	@Override
	public Object exec(String mthodName, Object[] parms) {
		if ("getWidget".equals(mthodName)) {
			return comp.getWidget();
		}
		return super.exec(mthodName, parms);
	}

	@Override
	public String[] getProps() {
		return GxtUtil.add(super.getProps(), props);
	}

	@Override
	public void addWidget(Component widget) {
		if (comp.isRendered()) {
			GxtUtil.addAfterRender(comp, widget);
		} else {
			MenuHelper.setWidget(comp, widget);
		}
	}

	@Override
	public List<Component> getChildren() {
		List<Component> l = new ArrayList<Component>();
		// LayoutDataを含めない(super)
		if (comp.getWidget() != null) {
			l.add((Component) comp.getWidget());
		}
		return l;
	}

	@Override
	public String getAddCode(Component widget, List<String>[] lists,
			String parentFiledName, String fieldName, Map<Object, Object> map) {
		return GxtUtil.getAddCode4Adapter(lists, parentFiledName, fieldName,
				map, service.getTag());
	}

	@Override
	public boolean isAddable() {
		return true;
	}

}
