/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design.gxt;

import jp.co.kpscorp.gwt.client.design.MyDraggable;

import com.extjs.gxt.ui.client.dnd.DragSource;
import com.extjs.gxt.ui.client.event.DNDEvent;
import com.extjs.gxt.ui.client.event.DragEvent;
import com.extjs.gxt.ui.client.event.DragListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.Grid;

public class MyDragSource extends DragSource {

	public MyDragSource(Component component) {
		super();
		this.component = component;

		listener = new DragListener() {

			@Override
			public void dragCancel(DragEvent de) {
				onDraggableDragCancel(de);
			}

			@Override
			public void dragEnd(DragEvent de) {
				onDraggableDragEnd(de);
			}

			@Override
			public void dragMove(DragEvent de) {
				onDraggableDragMove(de);
			}

			@Override
			public void dragStart(DragEvent de) {
				onDraggableDragStart(de);
			}

		};

		draggable = new MyDraggable(component);
		draggable.setUseProxy(true);
		draggable.setSizeProxyToSource(false);
		draggable.setMoveAfterProxyDrag(false);
		draggable.addDragListener(listener);
	}

	private int colIndex = -1;

	@Override
	protected void onDragStart(DNDEvent event) {
		super.onDragStart(event);
		if (event.component instanceof Grid) {
			Grid grid = (Grid) event.component;
			colIndex = grid.getView().findCellIndex(event.getTarget(), null);
		}
	}

	public int getColIndex() {
		return colIndex;
	}

}
