/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design;

import java.util.ArrayList;
import java.util.List;

import com.extjs.gxt.ui.client.widget.Component;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ImportTool {

	private DialogBox dc;

	public ImportTool(Component widget) {
		this(widget, true);
	}

	private boolean generate;

	private Widget widget;

	public ImportTool(Widget widget, boolean generate) {
		super();
		this.generate = generate;
		this.widget = widget;
		DeferredCommand.addCommand(new Command() {
			public void execute() {
				init();
			}
		});
	}

	private void init() {
		DesignPanel dp = DesignPanel.getInstance();
		Button clbt = new Button("close");
		dc = new DialogBox(false, true);
		VerticalPanel vp = new VerticalPanel();
		dc.setTitle("Design");
		dc.setText("Design");
		clbt.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				dc.hide();
			}
		});
		TextArea ta = new TextArea();
		dc.setStyleName("design-dialog");
		if (generate) {
			ta.setHeight("300px");
			ta.setWidth("300px");
			vp.add(ta);
		} else {
			vp.add(dp);
		}
		vp.add(clbt);
		dc.setWidget(vp);
		dc.center();
		List<Component> l = new ArrayList<Component>();
		l.add((Component) widget);
		dp.importWidget(l);
		if (generate) {
			ta.setText(dp.makeSource());
			ta.setFocus(true);
			ta.selectAll();
		}

	}

}
