/* D-RexGxt - D-RexGxt - GUI Design Tool for GWT
 * Copyright (c) 2008,  KPS Corporation
 * All rights reserved.
 *
 * Open Source License
 * ------------------------------------------------------------------------------------------
 * D-RexGxt is licensed under the terms of the Open Source GPL 3.0 license.
 *
 * http://www.gnu.org/licenses/gpl.html
 *
 * --
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 */
package jp.co.kpscorp.gwt.client.design;

import com.extjs.gxt.ui.client.dnd.DragSource;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.DateField;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.AnchorLayout;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.extjs.gxt.ui.client.widget.tree.Tree;

public class DropToolBar extends Window {

	public DropToolBar() {
		super();
		init();
	}

	private void init() {
		BarTool gxHT_1;
		TableData gxTBOD_1;

		BarTool gxHT_2;
		TableData gxTBOD_2;

		TableLayout gxTLO_1;
		setResizable(false);
		setMinWidth(78);
		setWidth(78);
		setBorders(true);
		setHeading("ToolBar");

		LayoutContainer lc = new LayoutContainer();
		lc.setLayout(new AnchorLayout());

		gxHT_1 = makeTool("image/toolbar/LC-30&30-gra.png",WidgetServiceFactory.getService(lc));
		gxTBOD_1 = new TableData();
		add(gxHT_1, gxTBOD_1);
		gxHT_2 = makeTool("image/toolbar/CP-30&30-gra.png",
				WidgetServiceFactory.getService(new ContentPanel()));
		gxTBOD_2 = new TableData();
		add(gxHT_2, gxTBOD_2);

		gxHT_1 = makeTool("image/toolbar/FP-30&30-gra.png",
				WidgetServiceFactory.getService(new FormPanel()));
		gxTBOD_1 = new TableData();
		add(gxHT_1, gxTBOD_1);
		gxTLO_1 = new TableLayout();
		gxHT_2 = makeTool("image/toolbar/TF-30&30-gra.png",
				WidgetServiceFactory.getService(new TextField()));
		gxTBOD_2 = new TableData();
		gxTLO_1.setColumns(2);
		add(gxHT_2, gxTBOD_2);


		gxHT_1 = makeTool("image/toolbar/Cb-30&30-gra.png",
				WidgetServiceFactory.getService(new ComboBox()));
		gxTBOD_1 = new TableData();
		add(gxHT_1, gxTBOD_1);
		gxHT_2 = makeTool("image/toolbar/Bt-30&30-gra.png",WidgetServiceFactory.getService(new Button()));
		gxTBOD_2 = new TableData();
		gxTLO_1.setColumns(2);
		add(gxHT_2, gxTBOD_2);

		gxHT_1 = makeTool("image/toolbar/Tr-30&30-gra.png",
				WidgetServiceFactory.getService(new Tree()));
		gxTBOD_1 = new TableData();
		add(gxHT_1, gxTBOD_1);
		gxHT_2 = makeTool("image/toolbar/Gr-30&30-gra.png",
				WidgetServiceFactory.getService(new Grid(null, null)));
		gxTBOD_2 = new TableData();
		gxTLO_1.setColumns(2);
		add(gxHT_2, gxTBOD_2);
		//gxTLO_1 = new TableLayout();

		gxHT_1 = makeTool("image/toolbar/TP-30&30-gra.png",
				WidgetServiceFactory.getService(new TabPanel()));
		gxTBOD_1 = new TableData();
		add(gxHT_1, gxTBOD_1);
		gxHT_2 = makeTool("image/toolbar/DF-30&30-gra.png",
				WidgetServiceFactory.getService(new DateField()));
		gxTBOD_2 = new TableData();
		gxTLO_1.setColumns(2);
		add(gxHT_2, gxTBOD_2);
//		gxTLO_1 = new TableLayout();


		gxHT_1 = makeTool("image/toolbar/TA-30&30-gra.png",
				WidgetServiceFactory.getService(new TextArea()));
		gxTBOD_1 = new TableData();
		add(gxHT_1, gxTBOD_1);
		gxHT_2 = makeTool("image/toolbar/Rd-30&30-gra.png",
				WidgetServiceFactory.getService(new Radio()));
		gxTBOD_2 = new TableData();
		add(gxHT_2, gxTBOD_2);
		gxTLO_1 = new TableLayout();
		gxTLO_1.setColumns(2);

		setLayout(gxTLO_1);
	}

	private BarTool makeTool(String src, WidgetService ws) {
		BarTool gxHT_1 = new BarTool();
		gxHT_1.setWidth(30);
		gxHT_1.setHeight(30);
		gxHT_1.setHtml("<img src=\"" + src + "\" width=30 height=30 />");
		gxHT_1.setService(ws);
		gxHT_1.setToolTip(ws.getLabel());
		DragSource ds = new DragSource(gxHT_1);
		ds.setData(gxHT_1);
		return gxHT_1;
	}
}
