#include <sys/stat.h>
#include <stdio.h>
#include <zlib.h>
#include <string.h>
#include <stdlib.h>
#include "mcast.h"

#define GZ  0
#define BZ2 1

int main(int argc, char *argv[])
{
  char buf[BUFSIZ];
  int len, err, mode, i, n, finished;
  gzFile in ;
  long long int nBytesToRead, nBytesRead;

  if(argc<2) { printf("usage %s [-gz|-bz2] ...",argv[0]); exit(0); }
  if(!strcmp(argv[1],"-gz")) mode=GZ;
  else if(!strcmp(argv[1],"-bz2")) mode=BZ2;
  else ;

  switch(mode) {
    case GZ:
      finished=0;
      in = gzdopen(0, "rb");
      for (i=2;i<argc;i++) {
        nBytesToRead = atoll(argv[i]);
        nBytesRead = 0;
        if(i>2) {
          /* skip CVolumeHeader */
          unsigned char vh[512];
          while(nBytesRead!=sizeof(vh)) { 
            len = gzread(in, vh, sizeof(vh)-nBytesRead);
            if(len<=0) { logit("%d : skip CVolumeHeader failed",i); finished=1; break; }
            nBytesRead += len;
          } 
        }
        if(finished) break;
        logit("%d : nBytesToRead = %d, nBytesRead = %d",i,nBytesToRead,nBytesRead);

        while( (nBytesToRead - nBytesRead) != 0 ) {
          n = sizeof(buf);
          if( (nBytesToRead - nBytesRead) < n ) n = nBytesToRead - nBytesRead;
          len = gzread(in, buf, n);
          if (len < 0) { logit("%s : %s", argv[0], gzerror(in, &err)); finished=1; break; }
          if (len == 0) { finished=1; break; }
          if(full_write(1, buf, len)!=len)
          //if ((int)fwrite(buf, 1, (unsigned)len, stdout) != len) 
            logit("%s : failed write %d",argv[0],i);
          nBytesRead += len;
        } //end while
        if(finished) break;
      } //end for
      if (gzclose(in) != Z_OK) logit("%s : failed gzclose",argv[0]);
      break;

    case BZ2:
      break;
  }

  logit("%s : done...",argv[0]);
  return 0;
}
