#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

void logit(char* logmsg,...)
{
/* use va_start va_end va_arg to operate va_list
 * see more information: man va_start
 */
  va_list args;
#ifdef DEBUG_STDOUT
  FILE *fp = stdout;
#else
  FILE *fp = fopen("/var/log/mcast.log","a+t");
#endif

  if(fp!=NULL) 
  {
    va_start(args, logmsg);
    vfprintf(fp,logmsg,args);
    fprintf(fp,"\n"); 
    va_end(args);
#ifndef DEBUG_STDOUT
    fclose(fp);
#endif
  }
}

#define HEXDUMP_BYTES_PER_LINE 16
void hex_print_with_offset(const u_char *cp, u_int length, u_int oset)
{
	u_int i, s;
	int nshorts;
	
	nshorts = (u_int) length / sizeof(u_short);
	i = 0;

	while (--nshorts >= 0) { 
		if ((i++ % 8) == 0) {
			(void)fprintf(stdout,"\n0x%04x\t", oset);
			oset += HEXDUMP_BYTES_PER_LINE;
		}
	    s = *cp++;
		(void)fprintf(stdout," %02x%02x", s, *cp++);
    }
    if (length & 1) {
	  if ((i % 8) == 0) (void)fprintf(stdout,"\n0x%04x\t", oset);
	  (void)fprintf(stdout," %02x", *cp);
	}
}

void logit_hex(char* msg, const u_char *cp, u_int length)
{
  printf("%s",msg);
  hex_print_with_offset(cp,length,0);
  printf("\n");
}
