/*
 * checkInodeForDevice
 *   the code is extracted from partimage-0.6.2.final 
 *   src/client/misc.cpp
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mount.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/resource.h>
#include <sys/utsname.h>

int getMajorMinor(char *szDevice, int *nMajor, int *nMinor)
{
  char szTemp[MAXPATHLEN];
  struct stat fStat;
  int i, j;
  int nRes;

  // get the major/minor number of the device
  memset(szTemp, 0, MAXPATHLEN);

  strncpy(szTemp, szDevice, MAXPATHLEN-1);
  szTemp[MAXPATHLEN-1] = '\0';
  i = strlen(szTemp)-1;
  while (i && isdigit(szTemp[i]))
    szTemp[i--] = '\0';

  // devfs: change part into disc
  if (i > 3 && !strncmp("part", szTemp+i-3, 4)) 
    strcpy(szTemp+i-3, "disc");

  nRes = stat(szTemp, &fStat);
  if (nRes == -1) return nRes;
  
  *nMajor = major(fStat.st_rdev);
  *nMinor = minor(fStat.st_rdev); // it is often 64 (for hdb, hdd, ...) or 0 (hda, hdc, ...)
  
  // get the minor number
  memset(szTemp, 0, MAXPATHLEN);
  for (i=0; (i < MAXPATHLEN) && (szDevice[i]) && (!isdigit(szDevice[i])); i++);
  for (j=0; (i < MAXPATHLEN) && (szDevice[i]) && (isdigit(szDevice[i])); i++, j++)
    szTemp[j] = szDevice[i];
  *nMinor += atoi(szTemp);

  return 0;
}

int checkInodeForDevice(char *szDevice)
{
  int nRes;
  struct stat fStat;
  int nMajor, nMinor;

  // must fail if the szDevice does not begins with "/dev/"
  if (strncmp(szDevice, "/dev/", 5) != 0) { 
    printf("%s does not begins with \"/dev/\"\n",szDevice); 
    return -1;
  }

  // check the inode exists (for example, hda17 can be missing in /dev)
  nRes = access(szDevice, F_OK);
  if (nRes == -1)
  {
    nRes = getMajorMinor(szDevice, &nMajor, &nMinor);
    if (nRes == -1) { 
      printf("getMajorMinor failed\n"); 
      return nRes;
    }

    // create the inode
    nRes = mknod(szDevice, S_IFBLK | S_IREAD | S_IWRITE | S_IRGRP | S_IROTH, 
                 makedev(nMajor, nMinor));
  }	
  
  // check the device is a block one
  nRes = stat(szDevice, &fStat);
  if (nRes == -1 || !S_ISBLK(fStat.st_mode)) { 
    printf("%s is not a block device\n",szDevice);
    return nRes;
  }
  
  return 0;
}

int main(int argc, char* argv[])
{
  if(argc!=2) {
    printf("Usage: %s device_name\n",argv[0]);
    exit(0);
  }
  checkInodeForDevice(argv[1]);
}
