#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description: calcalate the unzip size of partimge image file

echo "Calculate the unzip partimage image size .. This may take a long time .."

ocsroot="/home/partimag"
for image in `ls $ocsroot`; do

  echo "$image.."

  if [ "$image" = "." -o "$image" = ".." -o "$image" = "ocsmgrd" -o "$image" = "size" ]; then continue; fi

  if [ -d $ocsroot/$image ]; then
    ## for savedisk 
    disk="$(cat $ocsroot/$image/disk)"
    for imagefile in `ls $ocsroot/$image/$disk*`; do

      imagefile=${imagefile##*/}
      [ -f $ocsroot/$image/size ] && [ "$(grep "$imagefile" $ocsroot/$image/size)" != "" ] && continue
      imagefile_size="$(gunzip -l -q $ocsroot/$image/$imagefile | awk '{ print $2; }')"
      imagefile_ratio="$(gunzip -l -q $ocsroot/$image/$imagefile | awk '{ print $3; }')"
      if [ "$(echo "$imagefile_ratio" | grep -e "^-")" ]; then
        imagefile_size="$(gunzip < $ocsroot/$image/$imagefile | wc -c)"
      fi
      echo "$imagefile:$imagefile_size" >> $ocsroot/$image/size
    done
  else
    ## for save hda1
    imagefile="$image"
    [ -f $ocsroot/$image/size ] && [ "$(grep "$imagefile" $ocsroot/$image/size)" != "" ] && continue
    imagefile_size="$(gunzip -l -q $ocsroot/$image | awk '{ print $2; }')"
    imagefile_ratio="$(gunzip -l -q $ocsroot/$image | awk '{ print $3; }')"
    if [ "$(echo "$imagefile_ratio" | grep -e "^-")" ]; then
      imagefile_size="$(gunzip < $ocsroot/$image | wc -c)"
    fi
    echo "$imagefile:$imagefile_size" >> $ocsroot/size   
  fi

done
