#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <asm/processor.h>
#include <linux/tqueue.h>
#include <linux/interrupt.h>
#include <linux/slab.h>
#include <linux/net.h>
#include <net/sock.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <asm/uaccess.h>

#include "drbl.h"

static struct Drbl_Node {
  char *data;
  struct Drbl_Node *next;
} *nodes, *lastone;
static int n_nodes = 0; 

int append_to_nodes(const char* userdata, const int len) {

  struct Drbl_Node *ptr;
  int found=0;

  /* check if the node is already in the list */
  ptr = nodes;
  while(ptr!=NULL) {
    if(ptr->data!=NULL && strcmp(ptr->data,userdata)==0) {
      found=1; break;
    } 
    ptr = ptr->next;
  }

  /* append the new one to the end of the list */
  if(!found) {
    lastone->next = kmalloc(sizeof(struct Drbl_Node), GFP_USER);
    lastone = lastone->next;
    lastone->data = (char *)kmalloc(len, GFP_USER);
    memcpy(lastone->data, userdata, len);
    lastone->next = NULL;
    n_nodes++;
  }

  return 0;
}

/* nodes */
static int nodes_proc_read(
  char *page,
  char **start,
  off_t offset, 
  int count, 
  int *eof,
  void *data) {

  if(server) {
    /* server - show the data in the list */

    // Blake, 2003/10/29, assume the length of the data is less than the size of a page
    int len = 0 ;
    struct Drbl_Node *ptr = nodes;
    while(ptr!=NULL) {
      if(ptr->data!=NULL) {
        // make sure the length of the data is less than the size of a page
        if( (len+strlen(ptr->data)+1)>count ) { return len; }

        memcpy(page+len, ptr->data, strlen(ptr->data));
        len += strlen(ptr->data);
        //*(page+len+1)='\n';
        //len += 1;
      } 
      ptr = ptr->next;
    }
    return len;
  } else {
    /* client - get the nodes information from server */
    int len=0;
    if(nodes->data!=NULL) {

      struct socket *s = NULL;
      struct sockaddr_in sin;
      struct msghdr msg;
      struct iovec iov;
      int error, buflen, run;
      char* buf;
      mm_segment_t oldfs;
 
      /* ask to 'GET' */
      error = sock_create(PF_INET, SOCK_DGRAM, IPPROTO_UDP, &s);    
      if(error < 0) { 
        printk("<1>Error during creation of socket\n"); 
        goto out;
      }
      sin.sin_family = AF_INET;
      sin.sin_addr.s_addr = inet_addr(nodes->data);
      sin.sin_port = htons(DRBLNODED_PORT);

      printk("<1>%s(%4x):%d\n",nodes->data,inet_addr(nodes->data),DRBLNODED_PORT);
 
      buf = (char *)kmalloc(DRBL_QUANTUM+1, GFP_KERNEL);

      msg.msg_name = (void *)&sin;
      msg.msg_namelen = sizeof(sin);
      msg.msg_iov = &iov;
      msg.msg_iovlen = 1;

      strcpy(buf,"GET");
      buflen = strlen(buf);
      oldfs = get_fs();
      msg.msg_control = NULL;
      msg.msg_controllen = 0;
      msg.msg_iov->iov_base = buf;
      msg.msg_iov->iov_len = buflen;
      msg.msg_flags = MSG_NOSIGNAL;
      buflen = sock_sendmsg(s, &msg, buflen);
      set_fs(oldfs);

      /**
      run=1;
      while(run) { 
        msg.msg_control = NULL;
        msg.msg_controllen = 0;
        msg.msg_iov->iov_base = buf;
        msg.msg_iov->iov_len = (size_t)DRBL_QUANTUM;
        msg.msg_flags = 0;
     
        buflen = 0;
        oldfs = get_fs();
        set_fs(get_ds());
        buflen = sock_recvmsg(s, &msg, DRBL_QUANTUM, MSG_DONTWAIT);
        buf[buflen]='\0';
        set_fs(oldfs);     

        if( buflen<0 || buflen>DRBL_QUANTUM) goto outjob;

        if( strcmp(buf,"0.0.0.0")!=0 ) {
           // make sure the length of the data is less than the size of a page
           if( (len+buflen+1)>count ) { goto outjob; }

           memcpy(page+len, buf, buflen);
           len += buflen;
         
        } else { run = 0; }
      }
      **/
outjob:
      kfree(buf);
    }
out:
    return len;
  }
}

static int nodes_proc_write(
  struct file *file,
  const char *buffer,
  unsigned long count,
  void *data) {

  if(server) {
    /* server - append the data to the end of the list */
    char* userdata=NULL;

    /* copy the data from user */
    userdata=(char *)kmalloc(count+1, GFP_USER);
    if(copy_from_user(userdata, buffer, count)) {
      return -EFAULT;
    }
    userdata[count]='\0';

    /* append to the end of the nodes */
    append_to_nodes(userdata, strlen(userdata)+1);

    kfree(userdata);
  }
  else {
    /* client - send the nodes information to server */

  }
  return count;
}

/* server */
static int server_proc_read(
  char *page,
  char **start,
  off_t offset, 
  int count, 
  int *eof,
  void *data) {

  int len;
  if(nodes->data==NULL||strlen(nodes->data)==0) return 0;
  len=strlen(nodes->data);
  memcpy(page, nodes->data, len);
  return len;
}

static int server_proc_write(
  struct file *file,
  const char *buffer,
  unsigned long count,
  void *data) {

  if(nodes->data!=NULL) kfree(nodes->data);
  nodes->data = (char *)kmalloc(count+1, GFP_USER);
  if(copy_from_user(nodes->data, buffer, count)) {
    return -EFAULT;
  }  
  nodes->data[count]='\0';
  return count;
}

/* drblnoded */
DECLARE_WAIT_QUEUE_HEAD(wq);
DECLARE_WAIT_QUEUE_HEAD(wm);
volatile int drblnoded_finish = 0;
static int drblnoded(void *unused) {
  struct socket *s = NULL;
  struct sockaddr_in sin;
  int error = 0;

  sprintf(current->comm, "drblnoded");
  daemonize();

  /* initialize the socket */
  error = sock_create(PF_INET, SOCK_DGRAM, IPPROTO_UDP, &s);    
  if(error < 0) { 
    printk("<1>Error during creation of socket\n"); 
    goto out;
  }
  sin.sin_family = AF_INET;
  sin.sin_addr.s_addr = INADDR_ANY;
  sin.sin_port = htons(DRBLNODED_PORT);
  
  error = s->ops->bind(s, (struct sockaddr*)&sin, sizeof(sin));
  if(error < 0) {
    printk("<1>Error bind\n");
    goto out;
  }

  s->sk->reuse = 1;

  printk("<1>drbl_module: drblnoded begin\n");
 
  /* do the job */ 
  while(!drblnoded_finish) {

    struct msghdr msg;
    struct iovec iov;
    int len;
    char* buf;
    struct sockaddr_in sin2;
    mm_segment_t oldfs;
    
    if(skb_queue_empty(&(s->sk->receive_queue))) ;
    else {

      buf = (char *)kmalloc(DRBL_QUANTUM+1, GFP_KERNEL);

      msg.msg_name = (void *)&sin2;
      msg.msg_namelen = sizeof(sin2);
      msg.msg_iov = &iov;
      msg.msg_iovlen = 1;

      msg.msg_control = NULL;
      msg.msg_controllen = 0;
      msg.msg_iov->iov_base = buf;
      msg.msg_iov->iov_len = (size_t)DRBL_QUANTUM;
      msg.msg_flags = 0;
     
      len = 0;
      oldfs = get_fs();
      set_fs(get_ds());
      len = sock_recvmsg(s, &msg, DRBL_QUANTUM, MSG_DONTWAIT);
      buf[len]='\0';
      set_fs(oldfs);     

      if( len<0 || len>DRBL_QUANTUM) goto outjob;
      
      printk("<1>drbl_module: recv %s (%d)\n",buf,len);

      if(strcmp(buf,"GET")==0) {
        /* get the: node information from server */
        struct Drbl_Node *ptr = nodes->next;
        while(ptr!=NULL) {
          if(ptr->data!=NULL) {
            len = strlen(ptr->data);
            memcpy(buf,ptr->data,len);
            oldfs = get_fs();
            msg.msg_control = NULL;
            msg.msg_controllen = 0;
            msg.msg_iov->iov_base = buf;
            msg.msg_iov->iov_len = len;
            msg.msg_flags = MSG_NOSIGNAL;
            len = sock_sendmsg(s, &msg, len);
            set_fs(oldfs);
          } 
          ptr = ptr->next;
        }
        /* send the end */
        strcpy(buf,"0.0.0.0"); 
        len = strlen(buf);
        oldfs = get_fs();
        msg.msg_control = NULL;
        msg.msg_controllen = 0;
        msg.msg_iov->iov_base = buf;
        msg.msg_iov->iov_len = len;
        msg.msg_flags = MSG_NOSIGNAL;
        len = sock_sendmsg(s, &msg, len);
        set_fs(oldfs);
      }
      else if(strcmp(buf,"SET")==0) {
        /* set the node information to server */
        msg.msg_control = NULL;
        msg.msg_controllen = 0;
        msg.msg_iov->iov_base = buf;
        msg.msg_iov->iov_len = (size_t)DRBL_QUANTUM;
        msg.msg_flags = 0;
      
        len = 0;
        oldfs = get_fs();
        set_fs(get_ds());
        len = sock_recvmsg(s, &msg, DRBL_QUANTUM, MSG_DONTWAIT);
        buf[len]='\0';
        set_fs(oldfs);     

        if( len<0 || len>DRBL_QUANTUM) goto outjob;
      
        printk("<1>drbl_module: recv %s (%d)\n",buf,len);
     
        /* append the node information to the end of the node list */
        append_to_nodes(buf,sizeof(buf)+1);
      }
      else ;

outjob:
      kfree(buf);
     
    }

    interruptible_sleep_on_timeout(&wq, 1);
  }

  /* release the socket */
  sock_release(s);
  printk("<1>drbl_module: drblnoded end\n");
  wake_up_interruptible(&wm);
out:
  return error;
}

/* init/exit proc */
static struct {
    char *name;
    int (*read_proc)(char*,char**,off_t,int,int*,void*);
    int (*write_proc)(struct file*,const char*,unsigned long,void*);
} *p, ops[] = {
  {"server", &server_proc_read, &server_proc_write},
  {"nodes", &nodes_proc_read, &nodes_proc_write},
  {NULL,}
};
static struct proc_dir_entry *drbl_entry;

int proc_init() {
  struct proc_dir_entry *entry; 

  /* proc entry */
  drbl_entry = proc_mkdir("drbl",NULL);
  for(p=ops; p->name; p++) {
    entry = create_proc_entry(p->name, 0644, drbl_entry);
    entry->read_proc = p->read_proc;
    entry->write_proc = p->write_proc;
  }
  /* initialize the data structure */
  nodes = kmalloc(sizeof(struct Drbl_Node), GFP_USER);
  nodes->data=NULL;
  nodes->next=NULL;
  lastone = nodes;
  n_nodes = 0;
  /* initialize the daemon */
  //if(server) {
  //  kernel_thread(drblnoded,NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);
  //}
  return 0;
}

int proc_exit() {

  /* free the memory in nodes */
  struct Drbl_Node *ptr, *next;
  for(ptr=nodes; ptr!=NULL; ptr=next) {
    if(ptr->data!=NULL) kfree(ptr->data);
    next = ptr->next;
    kfree(ptr);
  }

  /* remove proc entry */
  for(p=ops; p->name; p++) {
    remove_proc_entry(p->name, drbl_entry);
  }
  remove_proc_entry("drbl",NULL);
  drbl_entry=NULL;

  /* end drblnoded */
  if(server) {
    drblnoded_finish = 1;
    interruptible_sleep_on(&wm);
  }

  return 0;
}

